/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class HTMLDialog
extends DialogWrapper {
    private final String text;
    private final HyperlinkListener hyperlinkListener;

    public HTMLDialog(String title, String text) {
        super(false);
        this.setTitle(title);
        this.text = text;
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        };
        this.init();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout(15, 0));
        Container iconContainer = new Container();
        iconContainer.setLayout(new BorderLayout());
        iconContainer.add((Component)new JLabel(CloverIcons.CLOVER_BIG), "North");
        panel.add((Component)iconContainer, "West");
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.addHyperlinkListener(this.hyperlinkListener);
        textPane.setText(this.text);
        textPane.setCaretPosition(0);
        textPane.setBackground(UIUtil.getOptionPaneBackground());
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(bodyRule);
        textPane.setOpaque(false);
        textPane.setBorder(null);
        panel.add((Component)textPane, "Center");
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }
}

