/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.tasks;

import clover.org.apache.commons.collections.list.SetUniqueList;
import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.util.MiscUtils;
import com.atlassian.clover.idea.util.tasks.AbstractCancellableTaskDelegate;
import com.atlassian.clover.idea.util.tasks.CancellableTask;
import com.atlassian.clover.idea.util.tasks.ExpirableTaskDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;

public class ExpirableTaskProcessor {
    private final List<ExpirableTaskDelegate> taskDelegateQueue = SetUniqueList.decorate(Lists.newLinkedList());
    private Task workerTask;
    private Boolean shouldBeHeadless;

    public ExpirableTaskProcessor() {
    }

    ExpirableTaskProcessor(Boolean shouldBeHeadless) {
        this.shouldBeHeadless = shouldBeHeadless;
    }

    public static ExpirableTaskProcessor getInstance() {
        return (ExpirableTaskProcessor)ServiceManager.getService(ExpirableTaskProcessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(ExpirableTaskDelegate taskDelegate) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<ExpirableTaskDelegate> list = this.taskDelegateQueue;
        synchronized (list) {
            this.taskDelegateQueue.add(0, taskDelegate);
        }
        this.schedule();
    }

    private void schedule() {
        if (this.workerTask == null && !this.taskDelegateQueue.isEmpty()) {
            this.workerTask = new WorkerTask();
            this.workerTask.queue();
        }
    }

    private class WorkerTaskDelegate
    extends AbstractCancellableTaskDelegate {
        public WorkerTaskDelegate() {
            super("Clover UI update");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private ExpirableTaskDelegate fetchNextTask() {
            List list = ExpirableTaskProcessor.this.taskDelegateQueue;
            synchronized (list) {
                Iterator taskIterator = ExpirableTaskProcessor.this.taskDelegateQueue.iterator();
                while (taskIterator.hasNext()) {
                    ExpirableTaskDelegate nextTaskDelegate = (ExpirableTaskDelegate)taskIterator.next();
                    taskIterator.remove();
                    if (!nextTaskDelegate.shouldProceed()) continue;
                    return nextTaskDelegate;
                }
            }
            return null;
        }

        @Override
        public void run(@NotNull ProgressIndicator progressIndicator) {
            ExpirableTaskDelegate td = this.fetchNextTask();
            while (td != null) {
                block4: {
                    final ExpirableTaskDelegate taskDelegate = td;
                    progressIndicator.checkCanceled();
                    progressIndicator.setText("Clover calculating test contribution coverage, about " + ExpirableTaskProcessor.this.taskDelegateQueue.size() + " more items left.");
                    try {
                        taskDelegate.run(progressIndicator);
                    }
                    catch (Exception e) {
                        if (!(e instanceof ProcessCanceledException)) {
                            Logger.getInstance().warn("Clover UI update task threw an exception", e);
                        }
                        MiscUtils.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                taskDelegate.onCancel();
                            }
                        });
                        break block4;
                    }
                    progressIndicator.checkCanceled();
                    MiscUtils.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            taskDelegate.onSuccess();
                        }
                    });
                }
                td = this.fetchNextTask();
            }
            ExpirableTaskProcessor.this.workerTask = null;
        }

        @Override
        public void onSuccess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCancel() {
            List list = ExpirableTaskProcessor.this.taskDelegateQueue;
            synchronized (list) {
                ExpirableTaskProcessor.this.taskDelegateQueue.clear();
                ExpirableTaskProcessor.this.workerTask = null;
            }
        }
    }

    private class WorkerTask
    extends CancellableTask {
        public WorkerTask() {
            super(null, new WorkerTaskDelegate());
        }

        public boolean isHeadless() {
            return ExpirableTaskProcessor.this.shouldBeHeadless == null ? super.isHeadless() : ExpirableTaskProcessor.this.shouldBeHeadless.booleanValue();
        }
    }
}

