/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.treetables;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.testexplorer.SourceFolderDescription;
import com.atlassian.clover.idea.treetables.CellRendererUtil;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private JTree tree;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof CoverageTreeModel.NodeWrapper) {
            userObject = ((CoverageTreeModel.NodeWrapper)userObject).getHasMetrics();
        }
        if (userObject instanceof TestCaseInfo) {
            TestCaseInfo tci = (TestCaseInfo)userObject;
            this.setIcon(CellRendererUtil.getIconForTestCaseInfo(tci));
            this.setText(tci.getTestName());
        } else if (userObject instanceof PackageFragment || userObject instanceof FullPackageInfo) {
            HasMetrics packageInfo = (HasMetrics)userObject;
            this.setIcon(expanded ? CloverIcons.PACKAGE_OPEN : CloverIcons.PACKAGE_CLOSED);
            String mangledName = new StringBuilder(packageInfo.getName()).append('\u202e').reverse().toString();
            this.setText(mangledName);
        } else if (userObject instanceof BaseClassInfo) {
            BaseClassInfo classInfo = (BaseClassInfo)userObject;
            this.setIcon(CellRendererUtil.getIconForClassInfo(classInfo));
            this.setText(classInfo.getName());
        } else if (userObject instanceof SourceFolderDescription) {
            SourceFolderDescription sourceFolder = (SourceFolderDescription)userObject;
            this.setText(sourceFolder.getName());
            if (sourceFolder.isTestFolder()) {
                this.setIcon(expanded ? CloverIcons.TEST_ROOT_FOLDER_OPEN : CloverIcons.TEST_ROOT_FOLDER);
            } else {
                this.setIcon(expanded ? CloverIcons.SOURCE_ROOT_FOLDER_OPEN : CloverIcons.SOURCE_ROOT_FOLDER);
            }
        } else if (userObject instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)userObject;
            this.setIcon(CellRendererUtil.getIconForMethodInfo(methodInfo));
            this.setText(methodInfo.getName());
        } else {
            this.setText(userObject != null ? userObject.toString() : "ERROR");
            this.setIcon(null);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        int maxWidth = this.tree.getWidth() - this.getBounds().x;
        if (maxWidth < this.getWidth()) {
            this.setSize(maxWidth, this.getHeight());
        }
        super.paint(g);
    }
}

