/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.idea.testexplorer.AbstractTestCaseNodeComparator;
import com.atlassian.clover.idea.treetables.AbstractColumnInfo;
import com.atlassian.clover.idea.util.ComparatorUtil;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.Formatting;
import java.util.Comparator;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;

public class TestStartedColumnInfo
extends AbstractColumnInfo<String> {
    private static final Comparator<DefaultMutableTreeNode> COMPARATOR = new AbstractTestCaseNodeComparator(){

        @Override
        int compare(TestCaseInfo tci1, TestCaseInfo tci2) {
            long time1 = tci1.getStartTime();
            long time2 = tci2.getStartTime();
            return ComparatorUtil.compareLong(time1, time2);
        }
    };

    public TestStartedColumnInfo() {
        super("Started", RALIGN_CELL_RENDERER);
    }

    public String valueOf(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TestCaseInfo) {
            TestCaseInfo tci = (TestCaseInfo)userObject;
            return Formatting.formatShortDate(new Date(tci.getStartTime()));
        }
        return null;
    }

    public String getPreferredStringValue() {
        return "XX XXX XX:XX:XX";
    }

    public Comparator<DefaultMutableTreeNode> getComparator() {
        return COMPARATOR;
    }
}

