/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import java.util.Collection;
import java.util.Map;
import org.openclover.util.Maps;

public class SimplePackageFragment
implements HasMetrics {
    private final String name;
    private Map<String, SimplePackageFragment> children = Maps.newHashMap();
    private FullPackageInfo concretePackage;

    SimplePackageFragment(String name) {
        this.name = name;
    }

    SimplePackageFragment add(String shortName) {
        SimplePackageFragment packageFragment = new SimplePackageFragment(shortName);
        this.children.put(shortName, packageFragment);
        return packageFragment;
    }

    public void setConcretePackage(FullPackageInfo concretePackage) {
        this.concretePackage = concretePackage;
    }

    public FullPackageInfo getConcretePackage() {
        return this.concretePackage;
    }

    SimplePackageFragment getChild(String shortName) {
        return this.children.get(shortName);
    }

    Collection<SimplePackageFragment> getChildren() {
        return this.children.values();
    }

    void cleanup() {
        this.children = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BlockMetrics getMetrics() {
        return this.concretePackage != null ? this.concretePackage.getMetrics() : null;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        return this.concretePackage != null ? this.concretePackage.getRawMetrics() : null;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        throw new UnsupportedOperationException("method setMetrics not implemented");
    }
}

