/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.treemap;

import clover.net.sf.jtreemap.swing.JTreeMap;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.TreeMapNodeBuilder;
import clover.net.sf.jtreemap.swing.ValuePercent;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.idea.coverage.CoverageListener;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.report.treemap.GoToSourceMouseListener;
import com.atlassian.clover.idea.report.treemap.IdeaCoverageColorProvider;
import com.atlassian.clover.idea.report.treemap.ProjectHeapMapBuilder;
import com.atlassian.clover.idea.report.treemap.ToolTipBuilder;
import com.atlassian.clover.idea.report.treemap.TreeMapVirtualFile;
import com.atlassian.clover.idea.util.vfs.DummyFileEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TreeMapEditor
extends DummyFileEditor
implements CoverageListener {
    private final JTreeMap treeMap;
    private final CoverageManager coverageManager;

    public TreeMapEditor(Project project, TreeMapVirtualFile virtualFile) {
        this.coverageManager = virtualFile.getCoverageManager();
        TreeMapNode root = new ProjectHeapMapBuilder().buildTree(this.coverageManager.getCoverage());
        this.treeMap = new JTreeMap(root);
        this.treeMap.setToolTipBuilder(new ToolTipBuilder(this.treeMap));
        this.treeMap.setColorProvider(new IdeaCoverageColorProvider());
        this.treeMap.addMouseListener(new GoToSourceMouseListener(project, this.treeMap));
        this.coverageManager.addCoverageListener(this);
    }

    @NotNull
    public JComponent getComponent() {
        return this.treeMap;
    }

    @NotNull
    public String getName() {
        return "CloverTreeMapEditor";
    }

    @Override
    public void update(CloverDatabase db) {
        TreeMapNode tmpRoot;
        if (db != null) {
            tmpRoot = new ProjectHeapMapBuilder().buildTree(db);
            if (tmpRoot.getChildren() == null || tmpRoot.getChildren().isEmpty()) {
                tmpRoot = this.buildCoverageUnavailableTree();
            }
        } else {
            tmpRoot = this.buildCoverageUnavailableTree();
        }
        final TreeMapNode newRoot = tmpRoot;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeMapEditor.this.treeMap.setRoot(newRoot);
                TreeMapEditor.this.treeMap.setActiveLeaf(null);
                TreeMapEditor.this.treeMap.setColorProvider(new IdeaCoverageColorProvider());
                TreeMapEditor.this.treeMap.repaint();
            }
        });
    }

    @Override
    public void dispose() {
        this.coverageManager.removeCoverageListener(this);
    }

    protected TreeMapNode buildCoverageUnavailableTree() {
        TreeMapNodeBuilder builder = new TreeMapNodeBuilder();
        TreeMapNode newRoot = builder.buildBranch("", null);
        TreeMapNode top = builder.buildBranch("Coverage information unavailable", newRoot);
        builder.buildLeaf("Coverage information unavailable", 1.0, new ValuePercent(0.0), top);
        return newRoot;
    }
}

