/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.treemap;

import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.TreeMapNodeBuilder;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.idea.report.treemap.ClassInfoValue;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import java.util.List;

public class ProjectHeapMapBuilder
extends TreeMapNodeBuilder {
    public TreeMapNode buildTree(CloverDatabase cloverDatabase) {
        FullProjectInfo projectInfo = cloverDatabase.getAppOnlyModel();
        TreeMapNode root = this.buildBranch("", null);
        List<? extends PackageInfo> packages = projectInfo.getAllPackages();
        for (PackageInfo packageInfo : packages) {
            TreeMapNode branch = this.buildBranch(packageInfo.getName(), root);
            List<? extends ClassInfo> classes = packageInfo.getClasses();
            for (ClassInfo classInfo : classes) {
                double weight = classInfo.getMetrics().getNumElements();
                ClassInfoValue value = new ClassInfoValue((FullClassInfo)classInfo);
                this.buildLeaf(classInfo.getName(), weight, value, branch);
            }
        }
        return root;
    }
}

