/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.IDEContext;
import com.atlassian.clover.idea.report.ReportWizardWorkspaceSettings;
import com.atlassian.clover.reporters.ShowLambdaFunctions;
import java.io.File;

public class WizardConfig {
    private final HtmlReport htmlConfig = new HtmlReport();
    private final PdfReport pdfConfig = new PdfReport();
    private final XmlReport xmlConfig = new XmlReport();
    private int type;
    public static final int HTML = 1;
    public static final int PDF = 2;
    public static final int XML = 3;
    private boolean useCurrentFilterSettings;
    private String contextSpec;

    public WizardConfig(IDEContext context) {
        String title = context.getProjectName() != null ? context.getProjectName() + " Coverage Report" : "Coverage Report";
        this.xmlConfig.setReportTitle(title);
        this.xmlConfig.setFile(new File(context.getProjectRootDirectory(), "report/coverage.xml"));
        this.xmlConfig.setShowLambda(ReportWizardWorkspaceSettings.getInstance().getShowLambda());
        this.pdfConfig.setReportTitle(title);
        this.pdfConfig.setFile(new File(context.getProjectRootDirectory(), "report/coverage.pdf"));
        this.htmlConfig.setReportTitle(title);
        this.htmlConfig.setDir(new File(context.getProjectRootDirectory(), "report/html"));
        this.htmlConfig.setIncludeSource(ReportWizardWorkspaceSettings.getInstance().isIncludeSources());
        this.htmlConfig.setIncludeFailedTestCoverage(ReportWizardWorkspaceSettings.getInstance().isIncludeFailedCoverage());
        this.htmlConfig.setShowLambda(ReportWizardWorkspaceSettings.getInstance().getShowLambda());
    }

    public HtmlReport getHtmlConfig() {
        return this.htmlConfig;
    }

    public PdfReport getPdfConfig() {
        return this.pdfConfig;
    }

    public XmlReport getXmlConfig() {
        return this.xmlConfig;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isHtml() {
        return this.type == 1;
    }

    public boolean isPdf() {
        return this.type == 2;
    }

    public boolean isXml() {
        return this.type == 3;
    }

    public boolean isUseCurrentFilterSettings() {
        return this.useCurrentFilterSettings;
    }

    public void setUseCurrentFilterSettings(boolean b) {
        this.useCurrentFilterSettings = b;
    }

    public String getContextSpec() {
        return this.contextSpec;
    }

    public void setContextSpec(String contextSpec) {
        this.contextSpec = contextSpec;
    }

    class XmlReport
    extends AbstractReport {
        private File file;
        private boolean includeLineInfo;

        XmlReport() {
            this.file = null;
            this.includeLineInfo = false;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public boolean isIncludeLineInfo() {
            return this.includeLineInfo;
        }

        public void setIncludeLineInfo(boolean b) {
            this.includeLineInfo = b;
        }
    }

    class PdfReport
    extends AbstractReport {
        private File file;

        PdfReport() {
            this.file = null;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    class HtmlReport
    extends AbstractReport {
        private File dir;
        private boolean includeSource;
        private boolean includeFailedCoverage;

        HtmlReport() {
            this.dir = null;
            this.includeSource = false;
            this.includeFailedCoverage = false;
        }

        public File getDir() {
            return this.dir;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public boolean isIncludeSource() {
            return this.includeSource;
        }

        public void setIncludeSource(boolean included) {
            this.includeSource = included;
        }

        public void setIncludeFailedTestCoverage(boolean included) {
            this.includeFailedCoverage = included;
        }

        public boolean isIncludeFailedCoverage() {
            return this.includeFailedCoverage;
        }
    }

    abstract class AbstractReport {
        private String reportTitle = null;
        private ShowLambdaFunctions showLambda = ShowLambdaFunctions.NONE;

        AbstractReport() {
        }

        public String getReportTitle() {
            return this.reportTitle;
        }

        public void setReportTitle(String s) {
            this.reportTitle = s;
        }

        public ShowLambdaFunctions getShowLambda() {
            return this.showLambda;
        }

        public void setShowLambda(ShowLambdaFunctions showLambda) {
            this.showLambda = showLambda;
        }
    }
}

