/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.report.ReportWizard;
import com.atlassian.clover.idea.report.ReportWizardPage;
import com.atlassian.clover.idea.report.WizardConfig;
import com.atlassian.clover.idea.util.ui.UIUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class SelectReportUI
extends ReportWizardPage {
    private JTextArea helpText;
    private JRadioButton htmlButton;
    private JRadioButton xmlButton;
    private JRadioButton pdfButton;
    private ButtonGroup buttonGroup;
    private JLabel htmlLabel = null;
    private JLabel pdfLabel = null;
    private JLabel xmlLabel = null;
    private JLabel htmlFileType = null;
    private JLabel pdfFileType = null;
    private JLabel xmlFileType = null;

    public SelectReportUI(ReportWizard wiz) {
        super(wiz);
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.getHelpText(), new GBC(0, 0).setSpan(3, 1).setInsets(5, 5, 5, 5).setAnchor(18).setFill(2));
        this.add((Component)this.getHtmlButton(), new GBC(0, 1).setInsets(5, 5, 5, 0).setAnchor(18).setFill(2));
        this.add((Component)this.getHtmlIconLabel(), new GBC(1, 1).setFill(1));
        this.add((Component)this.getHtmlButtonLabel(), new GBC(2, 1).setInsets(5, 0, 5, 5).setAnchor(18).setFill(2).setWeight(0.01, 0.0));
        this.add((Component)this.getPdfButton(), new GBC(0, 2).setInsets(0, 5, 5, 0).setAnchor(18).setFill(2));
        this.add((Component)this.getPdfIconLabel(), new GBC(1, 2).setFill(1));
        this.add((Component)this.getPdfButtonLabel(), new GBC(2, 2).setInsets(0, 0, 5, 5).setAnchor(18).setFill(2));
        this.add((Component)this.getXmlButton(), new GBC(0, 3).setInsets(0, 5, 5, 0).setAnchor(18).setFill(2));
        this.add((Component)this.getXmlIconLabel(), new GBC(1, 3).setFill(1));
        this.add((Component)this.getXmlButtonLabel(), new GBC(2, 3).setInsets(0, 0, 5, 5).setAnchor(18).setFill(2));
        this.add((Component)new JPanel(), new GBC(0, 6).setFill(3).setWeight(0.0, 0.1));
    }

    private void initListeners() {
        MouseAdapter htmlListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectReportUI.this.wizard.isHtmlAvailable()) {
                    SelectReportUI.this.getHtmlButton().setSelected(true);
                }
            }
        };
        this.getHtmlButtonLabel().addMouseListener(htmlListener);
        this.getHtmlIconLabel().addMouseListener(htmlListener);
        MouseAdapter pdfListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectReportUI.this.wizard.isPdfAvailable()) {
                    SelectReportUI.this.getPdfButton().setSelected(true);
                }
            }
        };
        this.getPdfButtonLabel().addMouseListener(pdfListener);
        this.getPdfIconLabel().addMouseListener(pdfListener);
        MouseAdapter xmlListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectReportUI.this.wizard.isXmlAvailable()) {
                    SelectReportUI.this.getXmlButton().setSelected(true);
                }
            }
        };
        this.getXmlButtonLabel().addMouseListener(xmlListener);
        this.getXmlIconLabel().addMouseListener(xmlListener);
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("Please select the type of report you would like to generate.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    private JLabel getHtmlButtonLabel() {
        if (this.htmlLabel == null) {
            this.htmlLabel = new JLabel("Html Report", null, 2);
            this.htmlLabel.setEnabled(this.wizard.isHtmlAvailable());
            if (!this.htmlLabel.isEnabled()) {
                this.htmlLabel.setToolTipText("You are not licensed to generate Html reports.");
            }
        }
        return this.htmlLabel;
    }

    private JLabel getHtmlIconLabel() {
        if (this.htmlFileType == null) {
            this.htmlFileType = new JLabel();
            this.htmlFileType.setEnabled(this.wizard.isHtmlAvailable());
            if (!this.htmlFileType.isEnabled()) {
                this.htmlFileType.setToolTipText("You are not licensed to generate Html reports.");
            }
        }
        return this.htmlFileType;
    }

    private JLabel getXmlButtonLabel() {
        if (this.xmlLabel == null) {
            this.xmlLabel = new JLabel("Xml Report", null, 2);
            this.xmlLabel.setEnabled(this.wizard.isXmlAvailable());
            if (!this.xmlLabel.isEnabled()) {
                this.xmlLabel.setToolTipText("You are not licensed to generate Xml reports.");
            }
        }
        return this.xmlLabel;
    }

    private JLabel getXmlIconLabel() {
        if (this.xmlFileType == null) {
            this.xmlFileType = new JLabel();
            this.xmlFileType.setEnabled(this.wizard.isXmlAvailable());
            if (!this.xmlFileType.isEnabled()) {
                this.xmlFileType.setToolTipText("You are not licensed to generate Xml reports.");
            }
        }
        return this.xmlFileType;
    }

    private JLabel getPdfButtonLabel() {
        if (this.pdfLabel == null) {
            this.pdfLabel = new JLabel("Pdf Report", null, 2);
            this.pdfLabel.setEnabled(this.wizard.isPdfAvailable());
            if (!this.pdfLabel.isEnabled()) {
                this.pdfLabel.setToolTipText("You are not licensed to generate Pdf reports.");
            }
        }
        return this.pdfLabel;
    }

    private JLabel getPdfIconLabel() {
        if (this.pdfFileType == null) {
            this.pdfFileType = new JLabel();
            this.pdfFileType.setEnabled(this.wizard.isPdfAvailable());
            if (!this.pdfFileType.isEnabled()) {
                this.pdfFileType.setToolTipText("You are not licensed to generate Pdf reports.");
            }
        }
        return this.pdfFileType;
    }

    private JRadioButton getHtmlButton() {
        if (this.htmlButton == null) {
            this.htmlButton = new JRadioButton();
            this.htmlButton.setEnabled(this.wizard.isHtmlAvailable());
            this.getButtonGroup().add(this.htmlButton);
        }
        return this.htmlButton;
    }

    private JRadioButton getXmlButton() {
        if (this.xmlButton == null) {
            this.xmlButton = new JRadioButton();
            this.xmlButton.setEnabled(this.wizard.isXmlAvailable());
            this.getButtonGroup().add(this.xmlButton);
        }
        return this.xmlButton;
    }

    private JRadioButton getPdfButton() {
        if (this.pdfButton == null) {
            this.pdfButton = new JRadioButton();
            this.pdfButton.setEnabled(this.wizard.isPdfAvailable());
            this.getButtonGroup().add(this.pdfButton);
        }
        return this.pdfButton;
    }

    @Override
    public void readConfig(WizardConfig config) {
        if (config.isHtml()) {
            this.getHtmlButton().setSelected(true);
        } else if (config.isXml()) {
            this.getXmlButton().setSelected(true);
        } else if (config.isPdf()) {
            this.getPdfButton().setSelected(true);
        }
    }

    @Override
    public void writeConfig(WizardConfig reportConfig) {
        if (this.getHtmlButton().isSelected()) {
            reportConfig.setType(1);
        } else if (this.getXmlButton().isSelected()) {
            reportConfig.setType(3);
        } else if (this.getPdfButton().isSelected()) {
            reportConfig.setType(2);
        }
    }

    @Override
    public String validateSettings() {
        return null;
    }

    public void setPdfFileTypeIcon(Icon i) {
        this.getPdfIconLabel().setIcon(i);
    }

    public void setXmlFileTypeIcon(Icon i) {
        this.getXmlIconLabel().setIcon(i);
    }

    public void setHtmlFileTypeIcon(Icon i) {
        this.getHtmlIconLabel().setIcon(i);
    }
}

