/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.report.ReportWizard;
import com.atlassian.clover.idea.report.ReportWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ReportWizardDialog
extends JDialog {
    private static final Border DEFAULT_BORDER = new EmptyBorder(8, 8, 8, 8);
    private NextAction nextAction;
    private PreviousAction previousAction;
    private FinishAction finishAction;
    private CancelAction cancelAction;
    private ReportWizard wizard;
    private ReportWizardPage currentPage;
    private int exitCode = -1;

    public ReportWizardDialog(ReportWizard wizard) {
        super(JOptionPane.getRootFrame(), "Generate Coverage Report", true);
        this.wizard = wizard;
    }

    public void setCurrentPage(ReportWizardPage c) {
        this.currentPage = c;
        Dimension currentSize = this.getSize();
        this.init();
        if (currentSize.getHeight() < this.getPreferredSize().getHeight()) {
            this.pack();
        } else {
            this.validate();
        }
    }

    public ReportWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected JComponent createCenterPanel() {
        return this.getCurrentPage();
    }

    protected Action[] createActions() {
        return new Action[]{this.getPreviousAction(), this.getNextAction(), this.getFinishAction(), this.getCancelAction()};
    }

    private JPanel createButtons(Action[] actions) {
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, 5, 0));
        for (Action action : actions) {
            JButton button = new JButton(action);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    protected JComponent createSouthPanel() {
        Action[] actions = this.createActions();
        JPanel panel = new JPanel(new GridBagLayout());
        if (actions.length > 0) {
            int gridx = 0;
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
            if (actions.length > 0) {
                JPanel buttonsPanel = this.createButtons(actions);
                panel.add((Component)buttonsPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 0, 0), 0, 0));
            }
        }
        return panel;
    }

    protected void init() {
        JComponent southPanel;
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(DEFAULT_BORDER);
        JComponent centerPanel = this.createCenterPanel();
        if (centerPanel != null) {
            contentPane.add((Component)centerPanel, "Center");
        }
        if ((southPanel = this.createSouthPanel()) != null) {
            contentPane.add((Component)southPanel, "South");
        }
        this.getContentPane().removeAll();
        this.getContentPane().add(contentPane);
        this.getContentPane().validate();
    }

    protected Action getPreviousAction() {
        if (this.previousAction == null) {
            this.previousAction = new PreviousAction();
        }
        return this.previousAction;
    }

    protected Action getNextAction() {
        if (this.nextAction == null) {
            this.nextAction = new NextAction();
        }
        return this.nextAction;
    }

    protected Action getFinishAction() {
        if (this.finishAction == null) {
            this.finishAction = new FinishAction();
        }
        return this.finishAction;
    }

    protected Action getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new CancelAction();
        }
        return this.cancelAction;
    }

    public final void close(int exitCode) {
        this.exitCode = exitCode;
        this.dispose();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportWizardDialog.this.wizard.doCancel();
        }
    }

    protected class FinishAction
    extends AbstractAction {
        public FinishAction() {
            super("Finish");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportWizardDialog.this.wizard.doFinish();
        }
    }

    protected class PreviousAction
    extends AbstractAction {
        public PreviousAction() {
            super("< Previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportWizardDialog.this.wizard.doPrevious();
        }
    }

    protected class NextAction
    extends AbstractAction {
        public NextAction() {
            super("Next >");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportWizardDialog.this.wizard.doNext();
        }
    }
}

