/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.report.AbstractConfigureUI;
import com.atlassian.clover.idea.report.ReportWizard;
import com.atlassian.clover.idea.report.WizardConfig;
import com.atlassian.clover.idea.util.ui.UIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ConfigurePdfUI
extends AbstractConfigureUI {
    private JTextArea helpText;
    private JTextField reportTitle;
    private JTextField outputFile;
    private JLabel reportTitleLabel;
    private JLabel outputFileLabel;

    public ConfigurePdfUI(ReportWizard wiz) {
        super(wiz);
        this.initComponents();
        this.initListeners();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.getHelpText(), new GBC(0, 0).setInsets(5, 5, 5, 5).setAnchor(18).setFill(2));
        this.add((Component)this.getReportTitleLabel(), new GBC(0, 1).setInsets(5, 5, 5, 5).setFill(2).setAnchor(18));
        this.add((Component)this.getReportTitle(), new GBC(0, 2).setInsets(0, 5, 5, 5).setFill(2).setAnchor(18).setWeight(0.01, 0.0));
        this.add((Component)this.getOutputFileLabel(), new GBC(0, 3).setInsets(5, 5, 5, 5).setFill(2).setAnchor(18));
        this.add(UIUtils.wrapWithFileChooser(this.wizard.getDialogWindow(), this.getOutputFile(), 0), new GBC(0, 4).setInsets(0, 5, 5, 5).setFill(2).setAnchor(18).setWeight(0.01, 0.0));
        this.add((Component)new JPanel(), new GBC(0, 5).setFill(3).setWeight(0.0, 0.1));
        this.add((Component)this.getUseFilters(), new GBC(0, 6).setFill(2).setInsets(0, 5, 5, 5).setAnchor(18));
    }

    @Override
    protected void initListeners() {
        this.getUseFilters().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurePdfUI.this.wizard.refreshState(!ConfigurePdfUI.this.getUseFilters().isSelected());
            }
        });
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("Please specify the report title and the output file. The output file is the file used for the generated report.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JTextField getOutputFile() {
        if (this.outputFile == null) {
            this.outputFile = new JTextField(20);
        }
        return this.outputFile;
    }

    private JLabel getOutputFileLabel() {
        if (this.outputFileLabel == null) {
            this.outputFileLabel = new JLabel("Output File:");
            this.outputFileLabel.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        }
        return this.outputFileLabel;
    }

    @Override
    public void readConfig(WizardConfig reportConfig) {
        WizardConfig.PdfReport config = reportConfig.getPdfConfig();
        this.getReportTitle().setText(config.getReportTitle());
        this.getOutputFile().setText(config.getFile().getAbsolutePath());
        this.getUseFilters().setSelected(reportConfig.isUseCurrentFilterSettings());
    }

    @Override
    public void writeConfig(WizardConfig reportConfig) {
        WizardConfig.PdfReport config = reportConfig.getPdfConfig();
        config.setReportTitle(this.getReportTitle().getText());
        config.setFile(new File(this.getOutputFile().getText()));
        reportConfig.setUseCurrentFilterSettings(this.getUseFilters().isSelected());
    }

    @Override
    public String validateSettings() {
        String txt = this.getOutputFile().getText();
        if (txt == null || txt.trim().length() == 0) {
            return "Please enter an output file.";
        }
        return null;
    }
}

