/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.projectview;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.projectview.PresentationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;

public class PsiDirectoryNodeWrapper
extends PsiDirectoryNode {
    public PsiDirectoryNodeWrapper(PsiDirectoryNode orig) {
        super(orig.getProject(), (PsiDirectory)orig.getValue(), orig.getSettings());
    }

    public void update(PresentationData presentation) {
        super.update(presentation);
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        IProjectPlugin plugin = ProjectPlugin.getPlugin(this.getProject());
        if (psiDirectory != null && plugin != null && plugin.getFeatureManager().isFeatureEnabled("clover-icondecoration")) {
            PresentationUtil.overlayPackagePresentation(presentation, (PsiElement)psiDirectory);
        }
    }

    static boolean canAnnotate(AbstractTreeNode abstractNode) {
        if (!(abstractNode instanceof PsiDirectoryNode)) {
            return false;
        }
        PsiDirectoryNode node = (PsiDirectoryNode)abstractNode;
        PsiDirectory psiDirectory = (PsiDirectory)node.getValue();
        return psiDirectory.getVirtualFile().isInLocalFileSystem() && ModuleUtil.findModuleForPsiElement((PsiElement)psiDirectory) != null;
    }
}

