/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit.config;

import com.atlassian.clover.idea.junit.config.TestOptimizationSettingsPanel;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

@State(name="CloverTestOptimization", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class TestOptimizationGlobalSettings
implements PersistentStateComponent<TestOptimizationGlobalSettings>,
Configurable {
    private boolean showAllTestsOptimizedOutDialog = true;
    private boolean showAllTestsOptimizedOutBalloon = true;
    private TestOptimizationSettingsPanel configPanel;

    public static TestOptimizationGlobalSettings getInstance() {
        return (TestOptimizationGlobalSettings)ServiceManager.getService(TestOptimizationGlobalSettings.class);
    }

    @Nls
    public String getDisplayName() {
        return "Test Optimization";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        if (this.configPanel == null) {
            this.configPanel = new TestOptimizationSettingsPanel();
        }
        return this.configPanel;
    }

    public void apply() throws ConfigurationException {
        this.showAllTestsOptimizedOutDialog = this.configPanel.getDisplayDialog().isSelected();
        this.showAllTestsOptimizedOutBalloon = this.configPanel.getDisplayBalloon().isSelected();
    }

    public void reset() {
        this.configPanel.getDisplayDialog().setSelected(this.showAllTestsOptimizedOutDialog);
        this.configPanel.getDisplayBalloon().setSelected(this.showAllTestsOptimizedOutBalloon);
    }

    public boolean isModified() {
        return this.showAllTestsOptimizedOutDialog != this.configPanel.getDisplayDialog().isSelected() || this.showAllTestsOptimizedOutBalloon != this.configPanel.getDisplayBalloon().isSelected();
    }

    public void disposeUIResources() {
        this.configPanel = null;
    }

    public TestOptimizationGlobalSettings getState() {
        return this;
    }

    public void loadState(TestOptimizationGlobalSettings settings) {
        this.showAllTestsOptimizedOutBalloon = settings.showAllTestsOptimizedOutBalloon;
        this.showAllTestsOptimizedOutDialog = settings.showAllTestsOptimizedOutDialog;
    }

    public boolean isShowAllTestsOptimizedOutDialog() {
        return this.showAllTestsOptimizedOutDialog;
    }

    public void setShowAllTestsOptimizedOutDialog(boolean showAllTestsOptimizedOutDialog) {
        this.showAllTestsOptimizedOutDialog = showAllTestsOptimizedOutDialog;
    }

    public boolean isShowAllTestsOptimizedOutBalloon() {
        return this.showAllTestsOptimizedOutBalloon;
    }

    public void setShowAllTestsOptimizedOutBalloon(boolean showAllTestsOptimizedOutBalloon) {
        this.showAllTestsOptimizedOutBalloon = showAllTestsOptimizedOutBalloon;
    }
}

