/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.junit.JUnitClassListProcessor;
import com.atlassian.clover.idea.junit.SavingsReporter;
import com.atlassian.clover.idea.junit.SocketUtils;
import com.atlassian.clover.idea.junit.config.OptimizedConfigurationSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SocketBasedJUnitClassListProcessor
extends JUnitClassListProcessor
implements Closeable {
    private static final int SOCKET_CONNECT_DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final int JUNIT_CLASS_LIST_DEFAULT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
    private final int junitClassListTimeout;
    private ServerSocket serverSocket;
    private Socket clientSocket;

    public SocketBasedJUnitClassListProcessor(SavingsReporter savingsReporter, File ideaGeneratedFile, Project currentProject, OptimizedConfigurationSettings optimizationSettings, int junitClassListTimeout) {
        super(savingsReporter, ideaGeneratedFile, currentProject, optimizationSettings);
        this.junitClassListTimeout = junitClassListTimeout;
    }

    public SocketBasedJUnitClassListProcessor(SavingsReporter savingsReporter, File ideaGeneratedFile, Project currentProject, OptimizedConfigurationSettings optimizationSettings) {
        this(savingsReporter, ideaGeneratedFile, currentProject, optimizationSettings, JUNIT_CLASS_LIST_DEFAULT_TIMEOUT);
    }

    public int processWhenSocketReady(int socket) {
        this.clientSocket = new Socket();
        try {
            this.clientSocket.connect(new InetSocketAddress(InetAddress.getByName(null), socket), SOCKET_CONNECT_DEFAULT_TIMEOUT);
        }
        catch (IOException e) {
            Logger.getInstance().warn("Cannot connect to JUnit runner synchronization socket", e);
            return -1;
        }
        try {
            this.serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            Logger.getInstance().warn("Cannot create proxy JUnit runner synchronization socket", e);
            this.close();
            return -1;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.currentProject, "Clover Test Optimization Task", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                indicator.setText("Waiting for JUnit class list");
                try {
                    DataInputStream dataInputStream = new DataInputStream(SocketBasedJUnitClassListProcessor.this.clientSocket.getInputStream());
                    SocketBasedJUnitClassListProcessor.this.clientSocket.setSoTimeout(SocketBasedJUnitClassListProcessor.this.junitClassListTimeout);
                    boolean wireValue = dataInputStream.readBoolean();
                    dataInputStream.close();
                    SocketBasedJUnitClassListProcessor.this.processFile();
                    SocketBasedJUnitClassListProcessor.this.notifyJUnitListener(wireValue);
                }
                catch (IOException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
                indicator.setText("Optimizing tests");
                if (!SocketBasedJUnitClassListProcessor.this.processFile()) {
                    this.onCancel();
                }
            }

            public void onCancel() {
                SocketBasedJUnitClassListProcessor.this.close();
            }
        };
        task.queue();
        return this.serverSocket.getLocalPort();
    }

    void notifyJUnitListener(boolean wireValue) throws IOException {
        Socket socket = this.serverSocket.accept();
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeBoolean(wireValue);
        dataOutputStream.close();
    }

    @Override
    public void close() {
        if (this.serverSocket != null) {
            SocketUtils.close(this.serverSocket);
            this.serverSocket = null;
        }
        if (this.clientSocket != null) {
            SocketUtils.close(this.clientSocket);
            this.clientSocket = null;
        }
    }
}

