/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.api.optimization.StringOptimizable;
import com.atlassian.clover.idea.ProjectPluginViaReflection;
import com.atlassian.clover.idea.coverage.SnapshotFileMutex;
import com.atlassian.clover.idea.junit.NoTestsFoundNotification;
import com.atlassian.clover.idea.junit.SavingsReporter;
import com.atlassian.clover.idea.junit.config.OptimizedConfigurationSettings;
import com.atlassian.clover.optimization.LocalSnapshotOptimizer;
import com.atlassian.clover.optimization.OptimizationSession;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.util.IOStreamUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;

public class JUnitClassListProcessor {
    protected final File ideaGeneratedFile;
    protected final SavingsReporter savingsReporter;
    protected final Project currentProject;
    protected final OptimizedConfigurationSettings optimizationSettings;
    static final String TMP_FILE_PREFIX = "idea_optimized_junit";
    static final String TMP_FILE_EXT = ".tmp";

    public JUnitClassListProcessor(SavingsReporter savingsReporter, File ideaGeneratedFile, Project currentProject, OptimizedConfigurationSettings optimizationSettings) {
        this.savingsReporter = savingsReporter;
        this.ideaGeneratedFile = ideaGeneratedFile;
        this.currentProject = currentProject;
        this.optimizationSettings = optimizationSettings;
    }

    boolean processFile() {
        List<Optimizable> underTest;
        ArrayList<String> header = Lists.newArrayList();
        try {
            underTest = JUnitClassListProcessor.readOptimizables(this.ideaGeneratedFile, header);
        }
        catch (IOException e) {
            Logger.getInstance().warn("Error reading JUnit test manifest file", e);
            return false;
        }
        if (underTest == null) {
            return false;
        }
        OptimizationSession[] sessionHolder = new OptimizationSession[1];
        Collection<Optimizable> optimized = this.optimize(this.currentProject, this.optimizationSettings, underTest, sessionHolder);
        if (optimized.size() == 0) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NoTestsFoundNotification.showNotifications();
                    }
                });
            } else {
                NoTestsFoundNotification.showNotifications();
            }
        }
        JUnitClassListProcessor.writeManifestFile(this.ideaGeneratedFile, header.toArray(new String[header.size()]), optimized);
        this.savingsReporter.reportSavings(this.currentProject, sessionHolder[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<Optimizable> optimize(final @NotNull Project project, @NotNull OptimizedConfigurationSettings settings, @NotNull List<Optimizable> optimizables, OptimizationSession[] sessionHolder) {
        Snapshot snapshot;
        CloverDatabase database = ProjectPluginViaReflection.getPlugin(project).getCoverageManager().getCoverage();
        if (database == null) {
            final String msg = "Clover coverage database not found for project '" + project.getName() + "'\n\nHave you enabled Build with Clover on this project?";
            Logger.getInstance().info(msg);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolWindowManager.getInstance((Project)project).notifyByBalloon("Cloverage", MessageType.WARNING, msg);
                }
            });
            return optimizables;
        }
        String initString = database.getInitstring();
        OptimizationOptions optimizationOptions = new OptimizationOptions.Builder().optimizableName("class").initString(initString).reorder(settings.getReorder()).maxCompilesBeforeStaleSnapshot(settings.isDiscardSnapshots() ? settings.getCompilesBeforeStaleSnapshot() : Integer.MAX_VALUE).minimize(settings.isMinimize()).build();
        SnapshotFileMutex mutex = (SnapshotFileMutex)ServiceManager.getService(SnapshotFileMutex.class);
        File snapshotFile = new File(Snapshot.fileNameForInitString(initString));
        mutex.lockFile(snapshotFile);
        try {
            snapshot = Snapshot.loadFrom(snapshotFile);
        }
        finally {
            mutex.releaseFile(snapshotFile);
        }
        if (snapshot == null) {
            try {
                Snapshot.generateFor(database).store();
            }
            catch (IOException e) {
                Logger.getInstance().warn("Cannot store snapshot file, following test run will not be optimized", e);
            }
            return optimizables;
        }
        LocalSnapshotOptimizer optimizer = new LocalSnapshotOptimizer(snapshot, database.getRegistry(), optimizationOptions);
        if (!optimizer.canOptimize()) {
            Logger.getInstance().info("Cannot optimize: " + optimizer.cannotOptimizeCause());
            if (optimizer.isTooStale()) {
                snapshot.delete();
            }
            return optimizables;
        }
        sessionHolder[0] = new OptimizationSession(optimizationOptions);
        List<Optimizable> optimized = optimizer.optimize(optimizables, sessionHolder[0]);
        return optimized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static List<Optimizable> readOptimizables(@NotNull File tmpFile, @NotNull List<String> headerHolder) throws IOException {
        ArrayList<Optimizable> arrayList;
        String line;
        BufferedReader reader;
        block9: {
            block8: {
                reader = null;
                reader = new BufferedReader(new FileReader(tmpFile));
                line = reader.readLine();
                if (line != null) break block8;
                List<Optimizable> list = null;
                IOStreamUtils.close(reader);
                return list;
            }
            if (line.startsWith("-junit")) {
                headerHolder.add(line);
                line = reader.readLine();
            }
            if (line != null) break block9;
            List<Optimizable> list = null;
            IOStreamUtils.close(reader);
            return list;
        }
        try {
            headerHolder.add(line);
            ArrayList<Optimizable> optimizables = Lists.newArrayList();
            String s = reader.readLine();
            while (s != null) {
                if (s.isEmpty()) {
                    headerHolder.add(s);
                } else {
                    optimizables.add(new StringOptimizable(s));
                }
                s = reader.readLine();
            }
            arrayList = optimizables;
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(reader);
            throw throwable;
        }
        IOStreamUtils.close(reader);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeManifestFile(@NotNull File file, @NotNull String[] header, @NotNull Collection<Optimizable> optimized) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            for (String line : header) {
                writer.println(line);
            }
            for (Optimizable optimizable : optimized) {
                writer.println(optimizable.getName());
            }
        }
        catch (IOException e) {
            boolean bl;
            try {
                Logger.getInstance().error("Cannot write to JUnit test manifest file", e);
                bl = false;
            }
            catch (Throwable throwable) {
                IOStreamUtils.close(writer);
                throw throwable;
            }
            IOStreamUtils.close(writer);
            return bl;
        }
        IOStreamUtils.close(writer);
        return true;
    }

    static void moveFile(File src, File dest) {
        if (!src.renameTo(dest)) {
            dest.delete();
            try {
                FileUtil.rename((File)src, (File)dest);
            }
            catch (IOException e) {
                Logger.getInstance().error("Cannot prepare optimized test list for JUnit runner", e);
            }
        }
    }
}

