/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.junit.JUnitClassListProcessor;
import com.atlassian.clover.idea.junit.SavingsReporter;
import com.atlassian.clover.idea.junit.config.OptimizedConfigurationSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileBasedJUnitClassListProcessor
extends JUnitClassListProcessor {
    public FileBasedJUnitClassListProcessor(SavingsReporter savingsReporter, File ideaGeneratedFile, Project currentProject, OptimizedConfigurationSettings optimizationSettings) {
        super(savingsReporter, ideaGeneratedFile, currentProject, optimizationSettings);
    }

    public File processWhenFileNotEmpty() {
        File processedFile;
        if (this.ideaGeneratedFile.length() > 0L) {
            this.processFile();
            return null;
        }
        try {
            processedFile = File.createTempFile("idea_optimized_junit", ".tmp");
        }
        catch (IOException e) {
            Logger.getInstance().error("Cannot create temporary file", e);
            return null;
        }
        processedFile.deleteOnExit();
        Task.Backgroundable task = new Task.Backgroundable(this.currentProject, "Clover Test Optimization Task", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                indicator.setText("Waiting for JUnit class list");
                long lastLength = 0L;
                long length = FileBasedJUnitClassListProcessor.this.ideaGeneratedFile.length();
                while (length == 0L || length != lastLength) {
                    lastLength = length;
                    if (!FileBasedJUnitClassListProcessor.this.ideaGeneratedFile.exists()) {
                        throw new ProcessCanceledException();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new ProcessCanceledException((Throwable)e);
                    }
                    length = FileBasedJUnitClassListProcessor.this.ideaGeneratedFile.length();
                }
                indicator.setText("Optimizing tests");
                if (FileBasedJUnitClassListProcessor.this.processFile()) {
                    JUnitClassListProcessor.moveFile(FileBasedJUnitClassListProcessor.this.ideaGeneratedFile, processedFile);
                } else {
                    this.onCancel();
                }
            }

            public void onCancel() {
                FileBasedJUnitClassListProcessor.this.ideaGeneratedFile.delete();
                processedFile.delete();
            }
        };
        task.queue();
        return processedFile;
    }
}

