/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.feature;

import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.atlassian.clover.idea.feature.FeatureTreeNode;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.openclover.util.Lists;

public class FeatureManager
implements FeatureListener {
    private final List<FeatureListener> listeners = Lists.newArrayList();
    private final List<FeatureTreeNode> featureTrees = Lists.newArrayList();

    public void addFeatureListener(FeatureListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void addFeatureListener(String featurePath, FeatureListener l) {
        FeatureTreeNode node = this.lookup(featurePath);
        if (node == null) {
            throw new IllegalArgumentException("Requested feature " + featurePath + " was not found");
        }
        node.addFeatureListener(l);
    }

    public void removeFeatureListener(String featurePath, FeatureListener l) {
        FeatureTreeNode node = this.lookup(featurePath);
        if (node == null) {
            throw new IllegalArgumentException("Requested feature " + featurePath + " was not found");
        }
        node.removeFeatureListener(l);
    }

    public void removeFeatureListener(FeatureListener l) {
        this.listeners.remove(l);
    }

    public void registerFeatureTree(FeatureTreeNode rootNode) {
        if (!this.featureTrees.contains(rootNode)) {
            this.featureTrees.add(rootNode);
            this.listenTo(rootNode);
        }
    }

    public boolean isFeatureEnabled(String featurePath) {
        FeatureTreeNode node = this.lookup(featurePath);
        return node != null && node.isFeatureEnabled();
    }

    public void setCategoryEnabled(String categoryPath, boolean b) {
        FeatureTreeNode node = this.lookup(categoryPath);
        if (node != null) {
            node.getCategory().setEnabled(b);
        }
    }

    private void listenTo(FeatureTreeNode node) {
        node.addFeatureListener(this);
        for (FeatureTreeNode child : node.getChildren()) {
            this.listenTo(child);
        }
    }

    @Override
    public void featureStateChanged(FeatureEvent evt) {
        for (FeatureListener listener : Lists.newArrayList(this.listeners)) {
            listener.featureStateChanged(evt);
        }
    }

    public FeatureTreeNode lookup(String featurePath) {
        StringTokenizer tokens = new StringTokenizer(featurePath, "-", false);
        FeatureTreeNode current = null;
        Iterator<FeatureTreeNode> nodes = this.featureTrees.iterator();
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            boolean found = false;
            while (nodes.hasNext() && !found) {
                FeatureTreeNode node = nodes.next();
                if (node.getCategoryName().compareTo(name) != 0) continue;
                found = true;
                current = node;
            }
            if (!found) {
                return null;
            }
            nodes = current.getChildren().iterator();
        }
        return current;
    }
}

