/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverageview;

import com.atlassian.clover.idea.NodeWrapperSelectionListener;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import java.util.Collection;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openclover.util.Sets;

class SelectionChangeNotifier
implements TreeSelectionListener {
    private Collection<NodeWrapperSelectionListener> listeners = Sets.newHashSet();

    SelectionChangeNotifier() {
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (evt.isAddedPath()) {
            TreePath path = evt.getPath();
            CoverageTreeModel.NodeWrapper node = CoverageTreeModel.getNodeForPath(path);
            this.notify(node);
        }
    }

    void notify(CoverageTreeModel.NodeWrapper node) {
        for (NodeWrapperSelectionListener listener : this.listeners) {
            listener.elementSelected(node);
        }
    }

    public void addListener(NodeWrapperSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(NodeWrapperSelectionListener listener) {
        this.listeners.remove(listener);
    }
}

