/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverageview;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.MethodSignatureInfo;
import com.atlassian.clover.api.registry.ParameterInfo;
import com.atlassian.clover.idea.NodeWrapperSelectionListener;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.SelectInCloverTarget;
import com.atlassian.clover.idea.SelectInCloverView;
import com.atlassian.clover.idea.actions.Constants;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.coverage.CoverageTreeFilter;
import com.atlassian.clover.idea.coverage.CoverageTreeListener;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.coverage.EventListenerInstallator;
import com.atlassian.clover.idea.coverageview.PackageInCloudAutoSelector;
import com.atlassian.clover.idea.coverageview.SelectionChangeNotifier;
import com.atlassian.clover.idea.report.jfc.FullyCoveredFilter;
import com.atlassian.clover.idea.treetables.TreeTableModelFactory;
import com.atlassian.clover.idea.treetables.TreeTablePanel;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.idea.util.ui.TreeExpansionHelper;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.registry.FileInfoRegion;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CoverageViewPanel
extends TreeTablePanel
implements ConfigChangeListener,
CoverageTreeListener,
DataProvider {
    private boolean autoScrollToSource;
    private boolean autoScrollFromSource;
    private boolean flattenPackages;
    private ModelScope currentModelScope;
    private boolean hideFullyCovered;
    private final Project project;
    private final SelectionChangeNotifier selectionChangeNotifier = new SelectionChangeNotifier();
    private final PackageInCloudAutoSelector packageInCloudAutoSelector;
    private CoverageTreeModel coverageTreeModel;
    private final String containingToolWindowId;
    private HasMetrics selectionOverride;
    private static final CoverageTreeFilter FULLY_COVERED_FILTER = new FullyCoveredFilter();

    public CoverageViewPanel(Project project, String containingToolWindowId) {
        super(project, TreeTableModelFactory.getCoverageTreeTableModel(null));
        this.project = project;
        this.containingToolWindowId = containingToolWindowId;
        this.packageInCloudAutoSelector = new PackageInCloudAutoSelector(project);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.treeTableView), "Center");
        this.initListeners();
    }

    private void initListeners() {
        AutoScrollToSourceHandler scrollToSourceHandler = new AutoScrollToSourceHandler();
        this.treeTableView.addMouseListener((MouseListener)scrollToSourceHandler);
        this.treeTableView.getTree().addTreeSelectionListener((TreeSelectionListener)this.selectionChangeNotifier);
        IdeaCloverConfig config = ProjectPlugin.getPlugin(this.project).getConfig();
        config.addConfigChangeListener(this);
        CoverageManager coverageManager = ProjectPlugin.getPlugin(this.project).getCoverageManager();
        coverageManager.addCoverageTreeListener(this);
        this.autoScrollToSource = config.isAutoScroll();
        this.autoScrollFromSource = config.isAutoScrollFromSource();
        this.flattenPackages = config.isFlattenPackages();
        this.currentModelScope = config.getModelScope();
        this.hideFullyCovered = config.isHideFullyCovered();
        EventListenerInstallator.install(this.project, FileEditorManagerListener.FILE_EDITOR_MANAGER, new AutoScrollFromSourceHandler());
        this.enableAutoCloudPackage(config.isAutoViewInCloudReport());
        SelectInCloverTarget.getInstance(this.project).addView(new SelectInCloverHandler(), 9);
        this.update(coverageManager.getCoverageTree());
    }

    private void enableAutoCloudPackage(boolean enable) {
        if (enable) {
            this.selectionChangeNotifier.addListener(this.packageInCloudAutoSelector);
        } else {
            this.selectionChangeNotifier.removeListener(this.packageInCloudAutoSelector);
        }
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        PropertyChangeEvent propertyChange;
        if (evt.hasPropertyChange("autoScroll")) {
            propertyChange = evt.getPropertyChange("autoScroll");
            this.autoScrollToSource = (Boolean)propertyChange.getNewValue();
        }
        if (evt.hasPropertyChange("autoScrollFromSource")) {
            propertyChange = evt.getPropertyChange("autoScrollFromSource");
            this.autoScrollFromSource = (Boolean)propertyChange.getNewValue();
        }
        if (evt.hasPropertyChange("flattenPackages")) {
            propertyChange = evt.getPropertyChange("flattenPackages");
            this.flattenPackages = (Boolean)propertyChange.getNewValue();
            this.update(this.coverageTreeModel);
        }
        if (evt.hasPropertyChange("modelScope")) {
            propertyChange = evt.getPropertyChange("modelScope");
            this.currentModelScope = (ModelScope)((Object)propertyChange.getNewValue());
            this.update(this.coverageTreeModel);
        }
        if (evt.hasPropertyChange("cloudAutoView")) {
            propertyChange = evt.getPropertyChange("cloudAutoView");
            this.enableAutoCloudPackage((Boolean)propertyChange.getNewValue());
        }
        if (evt.hasPropertyChange("hideFullyCovered")) {
            propertyChange = evt.getPropertyChange("hideFullyCovered");
            this.hideFullyCovered = (Boolean)propertyChange.getNewValue();
            this.update(this.coverageTreeModel);
        }
    }

    @Override
    public void update(final CoverageTreeModel model) {
        this.coverageTreeModel = model;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (model == null) {
                    CoverageViewPanel.this.selectionChangeNotifier.notify(null);
                    CoverageViewPanel.this.tableModel.setRoot(new DefaultMutableTreeNode(" Coverage data not loaded."));
                } else {
                    if (CoverageViewPanel.this.hideFullyCovered) {
                        if (!model.hasFilter(FULLY_COVERED_FILTER)) {
                            model.addFilter(FULLY_COVERED_FILTER);
                        }
                    } else if (model.hasFilter(FULLY_COVERED_FILTER)) {
                        model.removeFilter(FULLY_COVERED_FILTER);
                    }
                    boolean toSavedValue = CoverageViewPanel.this.autoScrollToSource;
                    try {
                        CoverageViewPanel.this.autoScrollToSource = false;
                        TreeExpansionHelper teh = new TreeExpansionHelper((JTree)CoverageViewPanel.this.treeTableView.getTree());
                        CoverageViewPanel.this.tableModel.setRoot(model.getClassTree(!CoverageViewPanel.this.flattenPackages, CoverageViewPanel.this.currentModelScope));
                        teh.restore((JTree)CoverageViewPanel.this.treeTableView.getTree());
                        if (CoverageViewPanel.this.selectionOverride != null) {
                            CoverageViewPanel.this.selectHasMetrics(CoverageViewPanel.this.selectionOverride);
                            CoverageViewPanel.this.selectionOverride = null;
                        }
                    }
                    finally {
                        CoverageViewPanel.this.autoScrollToSource = toSavedValue;
                    }
                }
            }
        });
    }

    public void ensureSelectionVisible() {
        TreeTableTree tree = this.treeTableView.getTree();
        tree.scrollPathToVisible(tree.getSelectionPath());
    }

    public void addElementSelectionListener(NodeWrapperSelectionListener listener) {
        this.selectionChangeNotifier.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToSource(TreePath path) {
        CoverageTreeModel.NodeWrapper node = CoverageTreeModel.getNodeForPath(path);
        if (node == null || !(node.getHasMetrics() instanceof FileInfoRegion)) {
            return;
        }
        FileInfoRegion region = (FileInfoRegion)((Object)node.getHasMetrics());
        File srcFile = ((FullFileInfo)region.getContainingFile()).getPhysicalFile();
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(srcFile);
        if (vf == null) {
            return;
        }
        ProjectPlugin.getPlugin(this.project).getFeatureManager().setCategoryEnabled("clover-reporting", true);
        FileEditorManager fem = FileEditorManager.getInstance((Project)this.project);
        int line = region.getStartLine() - 1;
        int column = region.getStartColumn() - 1;
        OpenFileDescriptor ofd = new OpenFileDescriptor(this.project, vf, line, column);
        boolean savedValue = this.autoScrollFromSource;
        try {
            this.autoScrollFromSource = false;
            fem.openTextEditor(ofd, true);
        }
        finally {
            this.autoScrollFromSource = savedValue;
        }
    }

    TreePath getPathForFile(VirtualFile file) {
        File f = VfsUtil.convertToFile(file);
        return f == null || this.coverageTreeModel == null ? null : this.coverageTreeModel.getPathForFile(f);
    }

    @Nullable
    TreePath getPathForHasMetrics(@Nullable HasMetrics hasMetrics) {
        return hasMetrics == null || this.coverageTreeModel == null ? null : this.coverageTreeModel.getPathForHasMetrics(hasMetrics);
    }

    boolean scrollFromSource(VirtualFile file) {
        return this.scrollToPath(this.getPathForFile(file));
    }

    boolean selectHasMetrics(@Nullable HasMetrics hasMetrics) {
        return this.scrollToPath(this.getPathForHasMetrics(hasMetrics));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scrollToPath(@Nullable TreePath path) {
        if (path != null) {
            boolean savedValue = this.autoScrollToSource;
            try {
                this.autoScrollToSource = false;
                this.treeTableView.getTree().expandPath(path.getParentPath());
                int row = this.treeTableView.getTree().getRowForPath(path);
                this.treeTableView.getSelectionModel().setSelectionInterval(row, row);
                Rectangle r = this.treeTableView.getCellRect(row, 0, false);
                this.treeTableView.scrollRectToVisible(r);
            }
            finally {
                this.autoScrollToSource = savedValue;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (Constants.SELECTED_HAS_METRICS.getName().equals(dataId)) {
            TreePath selection = this.treeTableView.getTree().getSelectionPath();
            Object object = selection == null ? null : ((DefaultMutableTreeNode)selection.getLastPathComponent()).getUserObject();
            return object instanceof CoverageTreeModel.NodeWrapper ? ((CoverageTreeModel.NodeWrapper)object).getHasMetrics() : null;
        }
        return null;
    }

    @Nullable
    private static PsiElement getEnclosingMethodOrClass(@Nullable PsiElement element) {
        PsiElement e;
        for (e = element; e != null && !(e instanceof PsiMethod) && !(e instanceof PsiClass); e = e.getParent()) {
        }
        return e;
    }

    @Nullable
    private HasMetrics getElement(@Nullable PsiElement selectedElement) {
        PsiClass psiClass;
        if (this.coverageTreeModel == null) {
            return null;
        }
        CloverDatabase database = this.coverageTreeModel.getCloverDatabase();
        if (database == null) {
            return null;
        }
        PsiElement selected = CoverageViewPanel.getEnclosingMethodOrClass(selectedElement);
        if (selected == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass = selected instanceof PsiClass ? (PsiClass)selected : ((PsiMethod)selected).getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiMethod psiMethod = selected instanceof PsiMethod ? (PsiMethod)selected : null;
        ClassInfo classInfo = database.getFullModel().findClass(psiClass.getQualifiedName());
        if (classInfo == null) {
            return null;
        }
        if (psiMethod == null) {
            return classInfo;
        }
        PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
        String psiName = psiMethod.getName();
        block0: for (MethodInfo methodInfo : classInfo.getMethods()) {
            MethodSignatureInfo signature = methodInfo.getSignature();
            ParameterInfo[] parameters = signature.getParameters();
            if (parameters == null || parameters.length != psiParameters.length || !psiName.equals(signature.getName())) continue;
            for (int i = 0; i < parameters.length; ++i) {
                PsiType psiType = psiParameters[i].getType();
                String sigType = parameters[i].getType();
                if (!sigType.equals(psiType.getCanonicalText()) && !sigType.equals(psiType.getPresentableText())) continue block0;
            }
            return methodInfo;
        }
        return classInfo;
    }

    private class SelectInCloverHandler
    implements SelectInCloverView {
        private SelectInCloverHandler() {
        }

        @Override
        public boolean canSelect(SelectInContext context) {
            Object selector = context.getSelectorInFile();
            return selector instanceof PsiElement && CoverageViewPanel.this.getElement((PsiElement)selector) != null;
        }

        @Override
        public boolean selectIn(SelectInContext context) {
            Object selector = context.getSelectorInFile();
            if (!(selector instanceof PsiElement)) {
                return false;
            }
            HasMetrics selected = CoverageViewPanel.this.getElement((PsiElement)selector);
            if (selected == null) {
                return false;
            }
            ToolWindowManager.getInstance((Project)CoverageViewPanel.this.project).getToolWindow(CoverageViewPanel.this.containingToolWindowId).activate(null);
            boolean done = CoverageViewPanel.this.selectHasMetrics(selected);
            if (!done && CoverageViewPanel.this.currentModelScope != ModelScope.ALL_CLASSES) {
                CoverageViewPanel.this.selectionOverride = selected;
                IdeaCloverConfig cloverConfig = ProjectPlugin.getPlugin(CoverageViewPanel.this.project).getConfig();
                cloverConfig.setModelScope(ModelScope.ALL_CLASSES);
                cloverConfig.notifyListeners();
                return false;
            }
            return done;
        }
    }

    private class AutoScrollFromSourceHandler
    extends FileEditorManagerAdapter
    implements CaretListener {
        private AutoScrollFromSourceHandler() {
        }

        public void caretPositionChanged(CaretEvent e) {
            DataContext dataContext;
            PsiFile psiFile;
            if (CoverageViewPanel.this.autoScrollFromSource && CoverageViewPanel.this.isShowing() && (psiFile = (PsiFile)DataKeys.PSI_FILE.getData(dataContext = DataManager.getInstance().getDataContext((Component)e.getEditor().getComponent()))) != null) {
                int pos = e.getEditor().getCaretModel().getOffset();
                PsiElement selectedPsi = psiFile.getViewProvider().findElementAt(pos, psiFile.getLanguage());
                CoverageViewPanel.this.selectHasMetrics(CoverageViewPanel.this.getElement(selectedPsi));
            }
        }

        public void caretAdded(CaretEvent caretEvent) {
        }

        public void caretRemoved(CaretEvent caretEvent) {
        }

        public void fileOpened(FileEditorManager source, VirtualFile file) {
            for (FileEditor editor : source.getEditors(file)) {
                if (!(editor instanceof TextEditor)) continue;
                TextEditor textEditor = (TextEditor)editor;
                textEditor.getEditor().getCaretModel().addCaretListener((CaretListener)this);
            }
        }
    }

    private class AutoScrollToSourceHandler
    extends MouseAdapter {
        private AutoScrollToSourceHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 || CoverageViewPanel.this.autoScrollToSource) {
                TreePath path = CoverageViewPanel.this.treeTableView.getTree().getPathForLocation(e.getX(), e.getY());
                CoverageViewPanel.this.scrollToSource(path);
            }
        }
    }
}

