/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.idea.util.tasks.CancellableTask;
import com.atlassian.clover.idea.util.tasks.CancellableTaskDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;

public class UpdateTaskScheduler {
    private final Project project;
    CancellableTaskDelegate pendingCoverageLoadTask;
    private UpdateCancellableTask currentTask;

    public UpdateTaskScheduler(Project project) {
        this.project = project;
    }

    public void scheduleReloadTask(final CancellableTaskDelegate taskDelegate) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateTaskScheduler.this.scheduleReloadTask(taskDelegate);
                }
            });
        }
        if (this.currentTask != null) {
            this.pendingCoverageLoadTask = null;
            this.currentTask.cancel();
        }
        this.currentTask = new UpdateCancellableTask(taskDelegate, true);
        this.currentTask.queue();
    }

    public void scheduleCoverageLoadTask(final CancellableTaskDelegate taskDelegate) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateTaskScheduler.this.scheduleCoverageLoadTask(taskDelegate);
                }
            });
        }
        if (this.currentTask == null) {
            this.pendingCoverageLoadTask = null;
            this.currentTask = new UpdateCancellableTask(taskDelegate, false);
            this.currentTask.queue();
        } else {
            this.pendingCoverageLoadTask = taskDelegate;
        }
    }

    public boolean isReloading() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.currentTask != null && this.currentTask.isReload;
    }

    public boolean isLoadingCoverage() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.currentTask != null && !this.currentTask.isReload;
    }

    public void cancel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.pendingCoverageLoadTask = null;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    private void schedule(CancellableTask finishedTask) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.currentTask == finishedTask) {
            if (this.pendingCoverageLoadTask != null) {
                this.currentTask = new UpdateCancellableTask(this.pendingCoverageLoadTask, false);
                this.pendingCoverageLoadTask = null;
                this.currentTask.queue();
            } else {
                this.currentTask = null;
            }
        }
    }

    public void restartCurrentTask() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = this.currentTask.copy();
            this.currentTask.queue();
        }
    }

    private class UpdateCancellableTask
    extends CancellableTask {
        private final boolean isReload;
        private final CancellableTaskDelegate delegate;

        private UpdateCancellableTask(CancellableTaskDelegate delegate, boolean isReload) {
            super(UpdateTaskScheduler.this.project, delegate);
            this.isReload = isReload;
            this.delegate = delegate;
        }

        @Override
        protected void onFinish() {
            UpdateTaskScheduler.this.schedule(this);
        }

        private UpdateCancellableTask copy() {
            return new UpdateCancellableTask(this.delegate, this.isReload);
        }
    }
}

