/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.idea.coverage.PercentBarColors;
import com.atlassian.clover.util.Formatting;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class PercentBarRenderer {
    private final Color foreground;
    private final Color background;

    public PercentBarRenderer() {
        this(PercentBarColors.GREEN_ON_RED);
    }

    public PercentBarRenderer(PercentBarColors colors) {
        this.foreground = colors.getForeground();
        this.background = colors.getBackground();
    }

    public void renderBar(Component c, Graphics g, float percent, int width, int height) {
        this.renderBar(c, g, percent, true, 0, 0, width, height);
    }

    public void renderBar(Component c, Graphics g, float percent, boolean showText, int originx, int originy, int width, int height) {
        Color oldColor = g.getColor();
        boolean drawpc = percent >= 0.0f;
        int maxTextWidth = 0;
        if (showText) {
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            maxTextWidth = metrics.stringWidth(" 999.9% ");
            int textHeight = metrics.getAscent();
            String pc = " " + Formatting.getPercentStr(percent) + " ";
            int textWidth = metrics.stringWidth(pc);
            g.setColor(Color.black);
            g.drawString(pc, originx + (maxTextWidth - textWidth), originy + ((height + textHeight) / 2 - 1));
        }
        int barWidth = width - maxTextWidth - 4;
        height /= 4;
        if (drawpc) {
            int greenW = (int)((float)barWidth * percent);
            g.setColor(this.foreground);
            g.fillRect(originx + maxTextWidth, originy + height, greenW, 2 + height * 2);
            g.setColor(this.background);
            g.fillRect(originx + maxTextWidth + greenW, originy + height, barWidth - greenW, 2 + height * 2);
        } else {
            g.setColor(new Color(230, 230, 230));
            g.fillRect(originx + maxTextWidth, originy + height, barWidth, 2 + height * 2);
        }
        g.setColor(new Color(120, 120, 120));
        g.drawRect(originx + maxTextWidth, originy + height, barWidth, 2 + height * 2);
        g.setColor(oldColor);
    }
}

