/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.idea.IdeaTestFilter;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.coverage.AcceptsCoverageTreeModel;
import com.atlassian.clover.idea.coverage.CoverageListener;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.coverage.CoverageTreeListener;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.coverage.ModelUtil;
import com.atlassian.clover.idea.coverage.UpdateTaskScheduler;
import com.atlassian.clover.idea.report.jfc.FileFilter;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.idea.util.tasks.AbstractCancellableTaskDelegate;
import com.atlassian.clover.idea.util.tasks.ProgressIndicatorAdapter;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.Path;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCoverageManager
implements CoverageManager,
AcceptsCoverageTreeModel,
ConfigChangeListener {
    private CoverageTreeModel treeModel;
    private String initString;
    private long span;
    private String filter = "";
    private final List<CoverageListener> listeners = new CopyOnWriteArrayList<CoverageListener>();
    private final List<CoverageTreeListener> treeListeners = new CopyOnWriteArrayList<CoverageTreeListener>();
    private Path sourcePath;
    private boolean loadPerTestData;
    private Project project;
    private final IdeaCloverConfig cloverConfig;
    private final UpdateTaskScheduler updateTaskScheduler;
    private final HasMetricsFilter.Invertable testFilter;
    private final HasMetricsFilter includeFilter;

    public DefaultCoverageManager(Project project, String initString) {
        this(project, initString, new FileFilter(project), new IdeaTestFilter(project));
    }

    DefaultCoverageManager(Project project, String initString, HasMetricsFilter includeFilter, HasMetricsFilter.Invertable ideaTestFilter) {
        this.initString = initString;
        this.project = project;
        this.cloverConfig = ProjectPlugin.getPlugin(project).getConfig();
        this.loadPerTestData = this.cloverConfig.isLoadPerTestData();
        this.cloverConfig.addConfigChangeListener(this);
        this.updateTaskScheduler = new UpdateTaskScheduler(project);
        this.testFilter = ideaTestFilter;
        this.includeFilter = includeFilter;
    }

    @Override
    public void cleanup() {
        this.updateTaskScheduler.cancel();
    }

    @Override
    public synchronized void setInitString(URL coverageUrl) {
        if (coverageUrl == null || coverageUrl.getFile() == null) {
            throw new IllegalArgumentException("Coverage URL can not be 'null'.");
        }
        File f = new File(coverageUrl.getFile());
        this.initString = f.getAbsolutePath();
        this.clearCache();
    }

    @Override
    public URL getInitString() {
        try {
            return new File(this.initString).toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getCoverageDatabasePath() {
        return this.initString;
    }

    @Override
    public void setSpan(long newSpan) {
        if (this.span != newSpan) {
            this.span = newSpan;
            this.clearCache();
        }
    }

    @Override
    public long getSpan() {
        return this.span;
    }

    @Override
    public void setContextFilter(String newFilter) {
        if (!this.filter.equals(newFilter)) {
            this.filter = newFilter;
            this.clearCache();
        }
    }

    @Override
    public String getContextFilter() {
        return this.filter;
    }

    private void clearCache() {
        this.setCoverageTree(null);
    }

    @Override
    @Nullable
    public CloverDatabase getCoverage() {
        return this.treeModel != null ? this.treeModel.getCloverDatabase() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCoverageTree(CoverageTreeModel model) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DefaultCoverageManager defaultCoverageManager = this;
        synchronized (defaultCoverageManager) {
            this.treeModel = model;
        }
        if (model != null && model.getCloverDatabase() != null) {
            this.applyCustomContextFilters(model.getCloverDatabase());
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDataProviderChange() {
        DefaultCoverageManager defaultCoverageManager = this;
        synchronized (defaultCoverageManager) {
            if (this.treeModel == null || this.treeModel.applyIncludePassedTestCoverageOnlyFilter(this.cloverConfig.isIncludePassedTestCoverageOnly())) {
                return;
            }
        }
        this.notifyListeners();
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("includePassedTestCoverageOnly")) {
            this.applyDataProviderChange();
        }
        if (evt.hasPropertyChange("loadPerTestData")) {
            boolean b = (Boolean)evt.getPropertyChange("loadPerTestData").getNewValue();
            CloverDatabase cloverDb = this.getCoverage();
            boolean needReload = !this.loadPerTestData && b && cloverDb != null && !cloverDb.getFullModel().hasTestResults();
            this.loadPerTestData = b;
            if (needReload) {
                this.loadCoverageData(false);
            }
        }
    }

    private void applyCustomContextFilters(CloverDatabase database) {
        List<Regexp> configuredRegexps = this.cloverConfig.getRegexpContexts();
        ContextStore contextStore = database.getContextStore();
        StringBuilder sb = new StringBuilder(this.cloverConfig.getContextFilterSpec());
        String separator = sb.length() == 0 ? "" : ", ";
        boolean needsChange = false;
        for (Regexp configuredRegexp : configuredRegexps) {
            NamedContext c;
            if (!configuredRegexp.isEnabled() || configuredRegexp.isDifferent(c = contextStore.getContext(configuredRegexp.getName()))) continue;
            needsChange = true;
            sb.append(separator);
            sb.append(configuredRegexp.getName());
            separator = ", ";
        }
        if (needsChange) {
            ContextSet filter = database.getContextSet(sb.toString());
            database.getRegistry().getProject().setContextFilter(filter);
        }
    }

    @Override
    @Nullable
    public synchronized CoverageTreeModel getCoverageTree() {
        return this.treeModel;
    }

    @Override
    public void addCoverageListener(CoverageListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeCoverageListener(CoverageListener l) {
        if (!this.listeners.remove(l)) {
            // empty if block
        }
    }

    @Override
    public void addCoverageTreeListener(CoverageTreeListener l) {
        if (!this.treeListeners.contains(l)) {
            this.treeListeners.add(l);
        }
    }

    @Override
    public void removeCoverageTreeListener(CoverageTreeListener l) {
        if (!this.treeListeners.remove(l)) {
            // empty if block
        }
    }

    public void notifyListeners() {
        for (CoverageListener coverageListener : this.listeners) {
            coverageListener.update(this.getCoverage());
        }
        for (CoverageTreeListener coverageTreeListener : this.treeListeners) {
            coverageTreeListener.update(this.getCoverageTree());
        }
    }

    public void reload(boolean flush) {
        if (flush) {
            this.clearCache();
        }
        this.reload();
    }

    @Override
    public boolean canLoadCoverageData() {
        if (this.updateTaskScheduler.isLoadingCoverage() || this.updateTaskScheduler.isReloading()) {
            return false;
        }
        CloverDatabase currentDatabase = this.getCoverage();
        return currentDatabase != null && currentDatabase.isCoverageOutOfDate();
    }

    @Override
    public void loadCoverageData(boolean forcePerTestData) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.getCoverageTree() == null) {
            this.reload();
            return;
        }
        CancellableCoverageLoadTaskDelegate coverageLoadTask = new CancellableCoverageLoadTaskDelegate(forcePerTestData);
        this.updateTaskScheduler.scheduleCoverageLoadTask(coverageLoadTask);
    }

    @Override
    public void lockRegistryForUpdate(Clover2Registry registry) {
        CloverDatabase currentDatabase;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.treeModel != null && (currentDatabase = this.treeModel.getCloverDatabase()) != null && currentDatabase.getRegistry() == registry) {
            this.treeModel.startRegistryUpdate();
        }
    }

    @Override
    public void releaseUpdatedRegistry(Clover2Registry registry) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CloverDatabase currentCoverage = this.getCoverage();
        if (currentCoverage == null || currentCoverage.getRegistry() != registry) {
            Logger.getInstance().warn("Modified registry is different from the currently loaded one, forcing reload");
            this.reload();
        } else {
            this.updateTaskScheduler.restartCurrentTask();
            this.treeModel.registryUpdated();
            this.notifyListeners();
        }
    }

    @Override
    public void reload() {
        this.reload(this);
    }

    void reload(AcceptsCoverageTreeModel recipient) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CoverageTreeModel newModel = new CoverageTreeModel("Project", this.initString, this.span, this.filter, true, this.sourcePath, this.cloverConfig.getModelScope(), this.loadPerTestData, this.testFilter, this.includeFilter, this.project);
        if (newModel.canLoad()) {
            CancellableReloadTaskDelegate reloadTask = new CancellableReloadTaskDelegate(newModel, recipient);
            this.updateTaskScheduler.scheduleReloadTask(reloadTask);
        } else {
            this.setCoverageTree(null);
        }
    }

    @Override
    public synchronized boolean canRefresh() {
        CloverDatabase database = this.getCoverage();
        if (database == null) {
            return this.initString != null && this.initString.length() > 0 && new File(this.initString).exists();
        }
        return database.isOutOfDate();
    }

    @Override
    public boolean delete() {
        if (!CloverUtils.scrubCoverageData(this.initString, true)) {
            return false;
        }
        this.reload(true);
        return true;
    }

    @Override
    public boolean clean() {
        if (!CloverUtils.scrubCoverageData(this.initString, false)) {
            return false;
        }
        this.reload(true);
        return true;
    }

    @Override
    public void setSourcePath(Path path) {
        this.sourcePath = path;
    }

    @Override
    public float getCurrentCoverage() {
        FullProjectInfo projectInfo = this.getSelectedScopeModel();
        return projectInfo == null ? -1.0f : projectInfo.getMetrics().getPcCoveredElements();
    }

    @Nullable
    public FullProjectInfo getSelectedScopeModel() {
        ModelScope scope = this.cloverConfig.getModelScope();
        CloverDatabase model = this.getCoverage();
        return ModelUtil.getModel(model, scope);
    }

    private class CancellableReloadTaskDelegate
    extends AbstractCancellableTaskDelegate {
        private final CoverageTreeModel newModel;
        private final AcceptsCoverageTreeModel recipient;

        public CancellableReloadTaskDelegate(CoverageTreeModel newModel, AcceptsCoverageTreeModel recipient) {
            super("Loading Clover coverage database");
            this.newModel = newModel;
            this.recipient = recipient;
        }

        @Override
        public void run(@NotNull ProgressIndicator progressIndicator) {
            ProgressIndicatorAdapter progressListener = new ProgressIndicatorAdapter(progressIndicator);
            this.newModel.load(progressListener);
            progressListener.handleProgress("Applying 'Passed Tests Coverage Only' filter", 0.0f);
            this.newModel.applyIncludePassedTestCoverageOnlyFilter(DefaultCoverageManager.this.cloverConfig.isIncludePassedTestCoverageOnly());
            progressListener.handleProgress("Creating tree model", 0.0f);
            this.newModel.createTree();
            progressListener.handleProgress("Tree model ready", 0.0f);
        }

        @Override
        public void onSuccess() {
            this.recipient.setCoverageTree(this.newModel);
        }
    }

    private class CancellableCoverageLoadTaskDelegate
    extends AbstractCancellableTaskDelegate {
        private CoverageTreeModel newModel;
        private CoverageTreeModel origModel;
        private final boolean forcePerTestData;

        public CancellableCoverageLoadTaskDelegate(boolean forcePerTestData) {
            super("Loading Coverage data");
            this.forcePerTestData = forcePerTestData;
        }

        @Override
        public void run(@NotNull ProgressIndicator progressIndicator) {
            this.origModel = DefaultCoverageManager.this.getCoverageTree();
            this.newModel = null;
            if (this.origModel != null) {
                this.newModel = this.origModel.safeCopy(progressIndicator);
                ProgressIndicatorAdapter progressListener = new ProgressIndicatorAdapter(progressIndicator);
                this.newModel.loadCoverageData(this.forcePerTestData || DefaultCoverageManager.this.loadPerTestData, progressListener);
                progressListener.handleProgress("Applying 'Passed Tests Coverage Only' filter", 0.0f);
                this.newModel.applyIncludePassedTestCoverageOnlyFilter(DefaultCoverageManager.this.cloverConfig.isIncludePassedTestCoverageOnly());
                progressListener.handleProgress("Creating tree model", 0.0f);
                this.newModel.createTree();
                progressListener.handleProgress("Tree model ready", 0.0f);
            }
        }

        @Override
        public void onSuccess() {
            if (this.origModel == DefaultCoverageManager.this.getCoverageTree()) {
                DefaultCoverageManager.this.setCoverageTree(this.newModel);
            } else {
                Logger.getInstance().debug("Discarding loaded data as the model has been changed in the meantime");
            }
        }
    }
}

