/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.coverage.BaseCoverageNodeViewer;
import com.atlassian.clover.idea.coverage.PercentBarColors;
import com.atlassian.clover.idea.coverage.PercentBarPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openclover.util.Maps;

public class CoverageNodeViewer
extends BaseCoverageNodeViewer {
    private final JPanel mPane = new JPanel();
    private JLabel mMethodsCovered = CoverageNodeViewer.makeLabel();
    private JLabel mStmtsCovered = CoverageNodeViewer.makeLabel();
    private JLabel mCondsCovered = CoverageNodeViewer.makeLabel();
    private PercentBarPanel mMethsPc = this.makePcBar();
    private static final String METRICS_FORM_COLUMNS_DEFINITION = "fill:d:g, fill:max(min;30dlu), 3dlu, fill:d:g, fill:max(min;30dlu), 3dlu";
    private static final int METRICS_FORM_COL_1 = 1;
    private static final int METRICS_FORM_COL_2 = 4;
    private static final int[][] METRICS_FORM_GROUPED_COLUMNS = new int[][]{{1, 4}};
    private static final RowSpec METRICS_FORM_ROW_SPEC = new RowSpec("pref");
    private static final String COVERAGE_FORM_COLUMNS_DEFINITION = "3dlu, pref, pref, fill:60dlu:g, 3dlu";
    private static final int COVERAGE_FORM_COL_1 = 2;
    private static final int COVERAGE_FORM_COL_2 = 4;
    private static final RowSpec COVERAGE_FORM_ROW_SPEC = new RowSpec("fill:pref");
    private JPanel coveragePane;
    private JPanel metricsPane;
    private final PercentBarPanel mStmtsPc = this.makePcBar();
    private final PercentBarPanel mCondsPc = this.makePcBar();
    private final PercentBarPanel mTotalPc = this.makePcBar();
    private final JLabel mLOC = CoverageNodeViewer.makeLabel();
    private final JLabel mNLOC = CoverageNodeViewer.makeLabel();
    private final JLabel mTComp = CoverageNodeViewer.makeLabel();
    private final JLabel mCompDensity = CoverageNodeViewer.makeLabel();
    private final JLabel mAvgComp = CoverageNodeViewer.makeLabel();
    private final JLabel mMethods = CoverageNodeViewer.makeLabel();
    private final JLabel mStatements = CoverageNodeViewer.makeLabel();
    private final JLabel mBranches = CoverageNodeViewer.makeLabel();
    private final JLabel mFiles = CoverageNodeViewer.makeLabel();
    private final JLabel mClasses = CoverageNodeViewer.makeLabel();
    private final JLabel mPackages = CoverageNodeViewer.makeLabel();
    private final JLabel mTestMethods = CoverageNodeViewer.makeLabel();
    private final JLabel mTests = CoverageNodeViewer.makeLabel();
    private final JLabel mTestsRun = CoverageNodeViewer.makeLabel();
    private final JLabel mTestsPassed = CoverageNodeViewer.makeLabel();
    private final PercentBarPanel mPCTestsPassed = this.makePcBar();
    private final JLabel mTestsSummary = CoverageNodeViewer.makeLabel();
    private String mTestsRunStr = "-";
    private String mTestsPassedStr = "-";
    private static final Font THE_FONT = new JLabel().getFont().deriveFont(0);
    private boolean isHorizontal;
    private final Map<Integer, RowSpec> testOnlyRows = Maps.newHashMap();
    private FormLayout metricsPaneLayout;
    private static final RowSpec EMPTY_ROW_SPEC = new RowSpec("0px");

    private PercentBarPanel makePcBar() {
        return this.makePcBar(PercentBarColors.GREEN_ON_RED);
    }

    private PercentBarPanel makePcBar(PercentBarColors colors) {
        PercentBarPanel pcbar = new PercentBarPanel(colors);
        pcbar.setOpaque(false);
        pcbar.setPercent(-1.0f);
        return pcbar;
    }

    public CoverageNodeViewer() {
        this.setupComponents();
    }

    public void clearNode() {
        this.setNode(null, null);
    }

    @Override
    public void setNode(HasMetrics hasMetrics, BaseCoverageNodeViewer.TestPassInfo testPassInfo) {
        super.setNode(hasMetrics, testPassInfo);
        this.mPane.invalidate();
    }

    @Override
    protected void setExtraStatsVisible(boolean enabled) {
        this.mLOC.setVisible(enabled);
        this.mNLOC.setVisible(enabled);
        this.mTComp.setVisible(enabled);
        this.mAvgComp.setVisible(enabled);
        this.mCompDensity.setVisible(enabled);
        this.mFiles.setVisible(enabled);
        this.mMethods.setVisible(enabled);
        this.mClasses.setVisible(enabled);
        this.mPackages.setVisible(enabled);
        this.mStatements.setVisible(enabled);
        this.mBranches.setVisible(enabled);
        this.mTestMethods.setVisible(enabled);
        this.mTests.setVisible(enabled);
        this.mTestsRun.setVisible(enabled);
        this.mTestsPassed.setVisible(enabled);
    }

    @Override
    protected void setNumPackagesText(String s) {
        this.mPackages.setText(s);
    }

    @Override
    protected void setNumClassesText(String s) {
        this.mClasses.setText(s);
    }

    @Override
    protected void setNumFilesText(String s) {
        this.mFiles.setText(s);
    }

    @Override
    protected void setNumMethodsText(String i) {
        this.mMethods.setText(i);
    }

    @Override
    protected void setNumBranchesText(String s) {
        this.mBranches.setText(s);
    }

    @Override
    protected void setNumStatementsText(String s) {
        this.mStatements.setText(s);
    }

    @Override
    protected void setNCLOCText(String i) {
        this.mNLOC.setText(i);
    }

    @Override
    protected void setLOCText(String i) {
        this.mLOC.setText(i);
    }

    @Override
    protected void setTotalPercent(float i) {
        this.mTotalPc.setPercent(i);
    }

    @Override
    protected void setCondsPercent(float setCondsPercent) {
        this.mCondsPc.setPercent(setCondsPercent);
    }

    @Override
    protected void setStmtsPercent(float i) {
        this.mStmtsPc.setPercent(i);
    }

    @Override
    protected void setMethodsPercent(float i) {
        this.mMethsPc.setPercent(i);
    }

    @Override
    protected void setCondsCoveredText(String s) {
        this.mCondsCovered.setText(s);
    }

    @Override
    protected void setStmtsCoveredText(String s) {
        this.mStmtsCovered.setText(s);
    }

    @Override
    protected void setMethodsCoveredText(String s) {
        this.mMethodsCovered.setText(s);
    }

    @Override
    protected void setAvgComplexityText(String s) {
        this.mAvgComp.setText(s);
    }

    @Override
    protected void setComplexityDensityText(String s) {
        this.mCompDensity.setText(s);
    }

    @Override
    protected void setTotalComplexityText(String s) {
        this.mTComp.setText(s);
    }

    @Override
    protected void setTestMethodsText(String s) {
        this.mTestMethods.setText(s);
    }

    @Override
    protected void setTestsText(String s) {
        this.mTests.setText(s);
    }

    @Override
    protected void setTestsRunText(String s) {
        this.mTestsRunStr = s;
        this.mTestsRun.setText(s);
        this.updateTestsSummary();
    }

    @Override
    protected void setTestsPassedText(String s) {
        this.mTestsPassedStr = s;
        this.mTestsPassed.setText(s);
        this.updateTestsSummary();
    }

    @Override
    protected void setTestsFailedText(String s) {
    }

    @Override
    protected void setTestsErrorsText(String s) {
    }

    @Override
    protected void setPCTestsPassed(float p) {
        this.mPCTestsPassed.setPercent(p);
    }

    @Override
    protected void setPCTestsFailed(float p) {
    }

    @Override
    protected void setPCTestsError(float p) {
    }

    private void updateTestsSummary() {
        this.mTestsSummary.setText(this.mTestsPassedStr + " / " + this.mTestsRunStr);
    }

    public JComponent getPane() {
        return this.mPane;
    }

    private static JLabel makeLabel() {
        return CoverageNodeViewer.makeLabel(null);
    }

    private static JLabel makeLabel(String aLabel) {
        JLabel label = aLabel == null ? new JLabel() : new JLabel(aLabel);
        label.setHorizontalAlignment(11);
        return label;
    }

    private static JLabel makeLabel(String aLabel, Font font) {
        JLabel label = CoverageNodeViewer.makeLabel(aLabel);
        label.setFont(font);
        return label;
    }

    private JPanel createCoveragePane() {
        JPanel coveragePane = new JPanel();
        coveragePane.setOpaque(false);
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Coverage and Tests");
        title.setTitleJustification(1);
        coveragePane.setBorder(title);
        FormLayout formLayout = new FormLayout(COVERAGE_FORM_COLUMNS_DEFINITION);
        coveragePane.setLayout((LayoutManager)formLayout);
        CellConstraints pcBarCC = new CellConstraints(4, 1);
        formLayout.appendRow(COVERAGE_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(coveragePane, "Methods: ", this.mMethodsCovered, 2, pcBarCC.gridY);
        coveragePane.add((Component)this.mMethsPc, pcBarCC);
        ++pcBarCC.gridY;
        formLayout.appendRow(COVERAGE_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(coveragePane, "Statements: ", this.mStmtsCovered, 2, pcBarCC.gridY);
        coveragePane.add((Component)this.mStmtsPc, pcBarCC);
        ++pcBarCC.gridY;
        formLayout.appendRow(COVERAGE_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(coveragePane, "Conditionals: ", this.mCondsCovered, 2, pcBarCC.gridY);
        coveragePane.add((Component)this.mCondsPc, pcBarCC);
        ++pcBarCC.gridY;
        formLayout.appendRow(new RowSpec("3dlu"));
        ++pcBarCC.gridY;
        formLayout.appendRow(COVERAGE_FORM_ROW_SPEC);
        JLabel totalTitle = CoverageNodeViewer.makeLabel("<html><b>TOTAL: ", THE_FONT);
        coveragePane.add((Component)totalTitle, new CellConstraints(2, pcBarCC.gridY));
        coveragePane.add((Component)this.mTotalPc, new CellConstraints(3, pcBarCC.gridY, 2, 1));
        ++pcBarCC.gridY;
        formLayout.appendRow(new RowSpec("6dlu"));
        ++pcBarCC.gridY;
        formLayout.appendRow(COVERAGE_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(coveragePane, "Tests passed: ", this.mTestsSummary, 2, pcBarCC.gridY);
        coveragePane.add((Component)this.mPCTestsPassed, pcBarCC);
        return coveragePane;
    }

    private JPanel createMetricsPane() {
        JPanel metricsPane = new JPanel();
        metricsPane.setOpaque(false);
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Metrics");
        title.setTitleJustification(1);
        metricsPane.setBorder(title);
        FormLayout formLayout = new FormLayout(METRICS_FORM_COLUMNS_DEFINITION);
        formLayout.setColumnGroups(METRICS_FORM_GROUPED_COLUMNS);
        metricsPane.setLayout((LayoutManager)formLayout);
        int row = 1;
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Lines of Code: ", this.mLOC, 1, row);
        CoverageNodeViewer.addField(metricsPane, "Conditionals: ", this.mBranches, 4, row);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "NC Lines of Code: ", this.mNLOC, 1, ++row);
        CoverageNodeViewer.addField(metricsPane, "Statements: ", this.mStatements, 4, row);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Methods: ", this.mMethods, 4, ++row);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Total Complexity: ", this.mTComp, 1, ++row);
        CoverageNodeViewer.addField(metricsPane, "Classes: ", this.mClasses, 4, row);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Avg Complexity: ", this.mAvgComp, 1, ++row);
        CoverageNodeViewer.addField(metricsPane, "Files: ", this.mFiles, 4, row);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Complexity Density: ", this.mCompDensity, 1, ++row);
        CoverageNodeViewer.addField(metricsPane, "Packages: ", this.mPackages, 4, row);
        RowSpec spacerSpec = new RowSpec("6dlu");
        formLayout.appendRow(spacerSpec);
        this.testOnlyRows.put(++row, spacerSpec);
        formLayout.appendRow(METRICS_FORM_ROW_SPEC);
        CoverageNodeViewer.addField(metricsPane, "Recorded Test Cases: ", this.mTests, 1, ++row);
        CoverageNodeViewer.addField(metricsPane, "Test Methods: ", this.mTestMethods, 4, row);
        this.testOnlyRows.put(row, METRICS_FORM_ROW_SPEC);
        this.metricsPaneLayout = formLayout;
        return metricsPane;
    }

    private static void addField(JPanel metricsPane, String aLabel, JComponent field, int labelColumn, int row) {
        CellConstraints cc = new CellConstraints(labelColumn, row);
        JLabel testsMethodsTitle = CoverageNodeViewer.makeLabel(aLabel, THE_FONT);
        Dimension minSize = testsMethodsTitle.getMinimumSize();
        minSize.width = 0;
        testsMethodsTitle.setMinimumSize(minSize);
        metricsPane.add((Component)testsMethodsTitle, cc);
        field.setFont(THE_FONT);
        metricsPane.add((Component)field, cc.xy(labelColumn + 1, row));
        testsMethodsTitle.setToolTipText(aLabel);
        field.setToolTipText(aLabel);
    }

    private void setupComponents() {
        this.mPane.setOpaque(false);
        this.mPane.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.mPane.setLayout(new BoxLayout(this.mPane, 1));
        this.coveragePane = this.createCoveragePane();
        this.metricsPane = this.createMetricsPane();
        this.mPane.add(this.coveragePane);
        this.mPane.add(this.metricsPane);
    }

    public void setTestMethodsVisible(boolean visible) {
        for (Map.Entry<Integer, RowSpec> entry : this.testOnlyRows.entrySet()) {
            this.metricsPaneLayout.setRowSpec(entry.getKey().intValue(), visible ? entry.getValue() : EMPTY_ROW_SPEC);
        }
        this.metricsPane.invalidate();
    }
}

