/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.content;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.content.ContentPlugin;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.atlassian.clover.idea.feature.FeatureManager;
import com.atlassian.clover.registry.FileElementVisitor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Point;

public class ToolTipPlugin
extends ContentPlugin
implements EditorMouseMotionListener,
FeatureListener {
    private LogicalPosition prevPosition;
    private boolean enabled = false;

    public ToolTipPlugin(Project proj, VirtualFile vf) {
        super(proj, vf);
    }

    @Override
    public void install(Editor e) {
        super.install(e);
        FeatureManager fManager = ProjectPlugin.getPlugin(this.project).getFeatureManager();
        fManager.addFeatureListener("clover-reporting-tooltips", this);
        this.setEnabled(fManager.isFeatureEnabled("clover-reporting-tooltips"));
        this.installedEditor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
    }

    @Override
    public void uninstall() {
        this.installedEditor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
        FeatureManager fManager = ProjectPlugin.getPlugin(this.project).getFeatureManager();
        fManager.removeFeatureListener("clover-reporting-tooltips", this);
        super.uninstall();
    }

    @Override
    public void refresh() {
        this.prevPosition = null;
    }

    public void mouseMoved(EditorMouseEvent evt) {
        if (!this.enabled || this.coverageInfo == null) {
            return;
        }
        Point pnt = evt.getMouseEvent().getPoint();
        LogicalPosition pos = this.installedEditor.xyToLogicalPosition(pnt);
        if (pos.equals((Object)this.prevPosition)) {
            return;
        }
        this.prevPosition = pos;
        if (!this.isCoverageUpToDate()) {
            if (this.hasPotentialCloverableElements()) {
                this.installedEditor.getContentComponent().setToolTipText("Coverage data out of date");
            }
            return;
        }
        TooltipProducer tooltipProducer = new TooltipProducer(pos);
        this.coverageInfo.visitElements(tooltipProducer);
        this.installedEditor.getContentComponent().setToolTipText(tooltipProducer.toString());
    }

    public void mouseDragged(EditorMouseEvent evt) {
    }

    @Override
    public void featureStateChanged(FeatureEvent evt) {
        this.setEnabled(evt.isEnabled());
    }

    private void setEnabled(boolean b) {
        if (this.enabled == b) {
            return;
        }
        this.enabled = b;
        if (!this.enabled) {
            this.installedEditor.getContentComponent().setToolTipText(null);
        }
    }

    private static class TooltipProducer
    implements FileElementVisitor {
        private final StringBuilder methodBuilder = new StringBuilder();
        private final StringBuilder branchBuilder = new StringBuilder();
        private final StringBuilder statementBuilder = new StringBuilder();
        private final LogicalPosition position;

        TooltipProducer(LogicalPosition position) {
            this.position = new LogicalPosition(position.line + 1, position.column);
        }

        private boolean contains(ElementInfo element) {
            LogicalPosition start = new LogicalPosition(element.getStartLine(), element.getStartColumn());
            LogicalPosition end = new LogicalPosition(element.getEndLine(), element.getEndColumn());
            return this.position.compareTo(start) >= 0 && this.position.compareTo(end) < 0;
        }

        @Override
        public void visitClass(ClassInfo info) {
        }

        @Override
        public void visitMethod(MethodInfo info) {
            if (this.contains(info)) {
                this.methodBuilder.append("Method <i>").append(info.getSimpleName()).append("</i> invoked ");
                this.methodBuilder.append(info.getHitCount());
                this.methodBuilder.append(" times<br>");
            }
        }

        @Override
        public void visitStatement(StatementInfo info) {
            if (this.contains(info)) {
                this.statementBuilder.append("Statement ");
                this.statementBuilder.append(info.getStartLine() + ":" + info.getStartColumn());
                this.statementBuilder.append(" executed ");
                this.statementBuilder.append(info.getHitCount());
                this.statementBuilder.append(" times<br>");
            }
        }

        @Override
        public void visitBranch(BranchInfo info) {
            if (this.contains(info)) {
                this.branchBuilder.append("Branch: true ");
                this.branchBuilder.append(info.getTrueHitCount());
                this.branchBuilder.append(" times, false ");
                this.branchBuilder.append(info.getFalseHitCount());
                this.branchBuilder.append(" times<br>");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<html><body>");
            sb.append((CharSequence)this.methodBuilder);
            sb.append((CharSequence)this.branchBuilder);
            sb.append((CharSequence)this.statementBuilder);
            sb.append("</body></html>");
            return sb.toString();
        }
    }
}

