/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.content;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.content.ContentManager;
import com.atlassian.clover.idea.coverage.CoverageTreeListener;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.SwingUtilities;

public abstract class ContentPlugin
implements DocumentListener,
CoverageTreeListener {
    protected static final Logger LOG = Logger.getInstance(ContentPlugin.class.getName());
    private final String openFilename;
    protected final Project project;
    protected CoverageTreeModel currentCoverageModel;
    protected FullFileInfo coverageInfo;
    protected Editor installedEditor;
    private final PsiFile psiFile;

    public ContentPlugin(Project proj, VirtualFile vf) {
        this.project = proj;
        this.openFilename = VfsUtil.getRootRelativeFilename(proj, vf);
        this.psiFile = PsiManager.getInstance((Project)this.project).findFile(vf);
    }

    public ContentManager getContentManager() {
        return ((ProjectPlugin)ProjectPlugin.getPlugin(this.project)).getContentManager();
    }

    public void install(Editor editor) {
        this.installedEditor = editor;
        IProjectPlugin projectPlugin = ProjectPlugin.getPlugin(this.project);
        projectPlugin.getCoverageManager().addCoverageTreeListener(this);
        this.update(projectPlugin.getCoverageManager().getCoverageTree());
        this.installedEditor.getDocument().addDocumentListener((DocumentListener)this);
    }

    public void uninstall() {
        this.installedEditor.getDocument().removeDocumentListener((DocumentListener)this);
        IProjectPlugin projectPlugin = ProjectPlugin.getPlugin(this.project);
        projectPlugin.getCoverageManager().removeCoverageTreeListener(this);
        this.installedEditor = null;
    }

    protected final boolean isDocumentSaved() {
        return !FileDocumentManager.getInstance().isDocumentUnsaved(this.installedEditor.getDocument());
    }

    protected boolean isCoverageUpToDate() {
        return this.coverageInfo != null && this.isDocumentSaved() && this.coverageInfo.validatePhysicalFile();
    }

    public void beforeDocumentChange(DocumentEvent evt) {
    }

    public void documentChanged(DocumentEvent evt) {
        this.refresh();
    }

    @Override
    public void update(CoverageTreeModel coverageModel) {
        this.currentCoverageModel = coverageModel;
        CloverDatabase db = coverageModel != null ? coverageModel.getCloverDatabase() : null;
        this.coverageInfo = db != null ? (FullFileInfo)db.getFullModel().findFile(this.openFilename) : null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentPlugin.this.refresh();
            }
        });
    }

    protected boolean hasPotentialCloverableElements() {
        if (this.coverageInfo != null && this.coverageInfo.getDataLength() != 0) {
            return true;
        }
        for (PsiElement psiElement : this.psiFile.getChildren()) {
            if (!(psiElement instanceof PsiClass) || !this.hasPotentialCloverableElements((PsiClass)psiElement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPotentialCloverableElements(PsiClass psiClass) {
        if (!(psiClass.isInterface() || psiClass.getMethods().length == 0 && psiClass.getInitializers().length == 0)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInnerClasses()) {
            if (!this.hasPotentialCloverableElements(aClass)) continue;
            return true;
        }
        return false;
    }

    public abstract void refresh();
}

