/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.ConfigPanelRunner;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.util.ui.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SpanConfigPanel
extends ConfigPanel {
    private JTextArea helpText;
    private final JTextField spanField = new JTextField(8);
    private final JLabel spanLabel = new JLabel("Span: ");
    private final JLabel validationMessage = new JLabel();

    public SpanConfigPanel() {
        this.spanField.setMinimumSize(this.spanField.getPreferredSize());
        this.validationMessage.setForeground(Color.RED);
        this.initLayout();
        this.initListeners();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getHelpText(), new GBC(1, 1).setInsets(0, 6, 5, 6).setSpan(3, 1).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)this.spanLabel, new GBC(1, 2).setInsets(0, 6, 6, 0).setFill(2));
        this.add((Component)this.spanField, new GBC(2, 2).setInsets(0, 0, 6, 0).setFill(2));
        this.add((Component)this.validationMessage, new GBC(3, 2).setInsets(0, 6, 6, 0).setFill(1));
    }

    private void initListeners() {
        this.spanField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.verify();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.verify();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.verify();
            }

            private void verify() {
                String span = SpanConfigPanel.this.spanField.getText();
                try {
                    if (span.length() != 0) {
                        new Interval(span);
                    }
                    SpanConfigPanel.this.validationMessage.setText("");
                }
                catch (NumberFormatException ex) {
                    SpanConfigPanel.this.validationMessage.setText("Invalid span");
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return "Span";
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("Specifies how far back data should be loaded, since last compile. (e.g. '30 s', '3 days', '2 mo', '1 year', or just blank to include all data since the last full rebuild)", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        try {
            String spanText = this.spanField.getText();
            if (spanText.equals("")) {
                spanText = "0";
            }
            Interval span = new Interval(spanText);
            config.setSpan(span.toString());
        }
        catch (NumberFormatException e) {
            config.setSpan("0");
        }
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        String span = config.getSpan();
        if (span != null && span.startsWith("0")) {
            span = "";
        }
        this.spanField.setText(span);
    }

    public static void main(String[] argv) {
        ConfigPanelRunner.run(new SpanConfigPanel());
    }
}

