/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.util.ui.UIUtils;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SourceHighlightConfigPanel
extends ConfigPanel {
    private JColorSelectionBox errorStripeBox;
    private JColorSelectionBox errorHighlightBox;
    private JColorSelectionBox oodStripeBox;
    private JColorSelectionBox oodHighlightBox;
    private JColorSelectionBox coveredStripeBox;
    private JColorSelectionBox coveredHighlightBox;
    private JColorSelectionBox coveredFailedHighlightBox;
    private JColorSelectionBox coveredFailedStripeBox;
    private JColorSelectionBox filteredHighlightBox;
    private JColorSelectionBox filteredStripeBox;
    private JTextArea helpText;
    private JPanel colourPanel;

    public SourceHighlightConfigPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.add((Component)this.getHelpText(), new GBC(0, 0).setInsets(6, 6, 10, 6).setSpan(1, 1).setFill(2).setAnchor(17).setWeight(1.0, 0.0));
        this.add((Component)this.getColourPanel(), new GBC(0, 1).setInsets(0, 6, 6, 6).setSpan(1, 1).setFill(2).setAnchor(17).setWeight(1.0, 0.0));
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("The source highlighting configurations allow you to customise the colour of source highlights and gutter marks.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JPanel getColourPanel() {
        if (this.colourPanel == null) {
            this.colourPanel = new JPanel();
            FormLayout formLayout = new FormLayout("p, p, p, p, p, p, p:grow", "p, p");
            formLayout.setColumnGroups((int[][])new int[][]{{2, 3, 4, 5, 6}});
            this.colourPanel.setLayout((LayoutManager)formLayout);
            CellConstraints cc = new CellConstraints();
            this.colourPanel.add((Component)new JLabel("Stripe:", 4), cc.xy(1, 1));
            this.colourPanel.add((Component)this.getErrorStripeBox(), cc.xy(2, 1));
            this.colourPanel.add((Component)this.getFailedCoveredStripeBox(), cc.xy(3, 1));
            this.colourPanel.add((Component)this.getCoveredStripeBox(), cc.xy(4, 1));
            this.colourPanel.add((Component)this.getFilteredStripeBox(), cc.xy(5, 1));
            this.colourPanel.add((Component)this.getOODStripeBox(), cc.xy(6, 1));
            this.colourPanel.add((Component)new JLabel("Highlight:", 4), cc.xy(1, 2));
            this.colourPanel.add((Component)this.getErrorHighlightBox(), cc.xy(2, 2));
            this.colourPanel.add((Component)this.getFailedCoveredHighlightBox(), cc.xy(3, 2));
            this.colourPanel.add((Component)this.getCoveredHighlightBox(), cc.xy(4, 2));
            this.colourPanel.add((Component)this.getFilteredHighlightBox(), cc.xy(5, 2));
            this.colourPanel.add((Component)this.getOODHighlightBox(), cc.xy(6, 2));
        }
        return this.colourPanel;
    }

    private JColorSelectionBox getErrorStripeBox() {
        if (this.errorStripeBox == null) {
            this.errorStripeBox = this.createColourBox("Uncovered", "Choose error stripe color for zero coverage");
        }
        return this.errorStripeBox;
    }

    private JColorSelectionBox getErrorHighlightBox() {
        if (this.errorHighlightBox == null) {
            this.errorHighlightBox = this.createColourBox("Uncovered", "Choose error highlight color for zero coverage");
        }
        return this.errorHighlightBox;
    }

    private JColorSelectionBox getOODStripeBox() {
        if (this.oodStripeBox == null) {
            this.oodStripeBox = this.createColourBox("Out-of-date", "Choose out-of-date stripe color for zero coverage");
        }
        return this.oodStripeBox;
    }

    private JColorSelectionBox getOODHighlightBox() {
        if (this.oodHighlightBox == null) {
            this.oodHighlightBox = this.createColourBox("Out-of-date", "Choose out-of-date highlight color for zero coverage");
        }
        return this.oodHighlightBox;
    }

    private JColorSelectionBox getCoveredStripeBox() {
        if (this.coveredStripeBox == null) {
            this.coveredStripeBox = this.createColourBox("Covered", "Choose stripe color for covered code");
        }
        return this.coveredStripeBox;
    }

    private JColorSelectionBox getCoveredHighlightBox() {
        if (this.coveredHighlightBox == null) {
            this.coveredHighlightBox = this.createColourBox("Covered", "Choose highlight color for covered code");
        }
        return this.coveredHighlightBox;
    }

    private JColorSelectionBox getFailedCoveredStripeBox() {
        if (this.coveredFailedStripeBox == null) {
            this.coveredFailedStripeBox = this.createColourBox("Failed", "Choose stripe color for code covered by failed tests only");
        }
        return this.coveredFailedStripeBox;
    }

    private JColorSelectionBox getFailedCoveredHighlightBox() {
        if (this.coveredFailedHighlightBox == null) {
            this.coveredFailedHighlightBox = this.createColourBox("Failed", "Choose highlight color for code covered by failed tests only");
        }
        return this.coveredFailedHighlightBox;
    }

    private JColorSelectionBox getFilteredStripeBox() {
        if (this.filteredStripeBox == null) {
            this.filteredStripeBox = this.createColourBox("Excluded", "Choose stripe color for excluded code");
        }
        return this.filteredStripeBox;
    }

    private JColorSelectionBox getFilteredHighlightBox() {
        if (this.filteredHighlightBox == null) {
            this.filteredHighlightBox = this.createColourBox("Excluded", "Choose highlight color for excluded code");
        }
        return this.filteredHighlightBox;
    }

    private JColorSelectionBox createColourBox(String txt, String popupTxt) {
        return new JColorSelectionBox(txt, popupTxt);
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        config.setCoveredHighlight(this.getCoveredHighlightBox().getSelectedColour());
        config.setCoveredStripe(this.getCoveredStripeBox().getSelectedColour());
        config.setNotCoveredHighlight(this.getErrorHighlightBox().getSelectedColour());
        config.setNotCoveredStripe(this.getErrorStripeBox().getSelectedColour());
        config.setOutOfDateHighlight(this.getOODHighlightBox().getSelectedColour());
        config.setOutOfDateStripe(this.getOODStripeBox().getSelectedColour());
        config.setFailedCoveredHighlight(this.getFailedCoveredHighlightBox().getSelectedColour());
        config.setFailedCoveredStripe(this.getFailedCoveredStripeBox().getSelectedColour());
        config.setFilteredHighlight(this.getFilteredHighlightBox().getSelectedColour());
        config.setFilteredStripe(this.getFilteredStripeBox().getSelectedColour());
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        this.getCoveredHighlightBox().setSelectedColour(config.getCoveredHighlight());
        this.getCoveredStripeBox().setSelectedColour(config.getCoveredStripe());
        this.getErrorHighlightBox().setSelectedColour(config.getNotCoveredHighlight());
        this.getErrorStripeBox().setSelectedColour(config.getNotCoveredStripe());
        this.getOODHighlightBox().setSelectedColour(config.getOutOfDateHighlight());
        this.getOODStripeBox().setSelectedColour(config.getOutOfDateStripe());
        this.getFailedCoveredHighlightBox().setSelectedColour(config.getFailedCoveredHighlight());
        this.getFailedCoveredStripeBox().setSelectedColour(config.getFailedCoveredStripe());
        this.getFilteredHighlightBox().setSelectedColour(config.getFilteredHighlight());
        this.getFilteredStripeBox().setSelectedColour(config.getFilteredStripe());
    }

    @Override
    public String getTitle() {
        return "Source Highlighting";
    }

    @Override
    public void enableConfig(boolean b) {
        super.enableConfig(b);
    }

    private static class JColorSelectionBox
    extends JPanel {
        JColorSelectionBox(String txt, final String colorSelectionTxt) {
            this.add((Component)new JLabel(txt), new Insets(8, 8, 8, 8));
            this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            final JColorSelectionBox self = this;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Color initialColour = self.getSelectedColour() != null ? self.getSelectedColour() : JColorSelectionBox.this.getBackground();
                            Color newColor = JColorChooser.showDialog(self, colorSelectionTxt, initialColour);
                            if (newColor != null) {
                                JColorSelectionBox.this.setSelectedColour(newColor);
                            }
                        }
                    });
                }
            });
        }

        void setSelectedColour(Color c) {
            this.setBackground(c);
        }

        Color getSelectedColour() {
            return this.getBackground();
        }
    }
}

