/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.IdeaIDEContext;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.ContextFilterPane;
import com.atlassian.clover.idea.config.EnabledConfigPanel;
import com.atlassian.clover.idea.config.FlushPolicyConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.GeneralConfigPanel;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.InitStringConfigPanel;
import com.atlassian.clover.idea.config.InstrumentationConfigPanel;
import com.atlassian.clover.idea.config.PerTestLoadConfigPanel;
import com.atlassian.clover.idea.config.ProjectRebuildConfigPanel;
import com.atlassian.clover.idea.config.RefreshPolicyConfigPanel;
import com.atlassian.clover.idea.config.SourceHighlightConfigPanel;
import com.atlassian.clover.idea.config.SpanConfigPanel;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openclover.util.Lists;

public class ProjectConfigPanel
extends JPanel
implements ActionListener,
ConfigChangeListener {
    private static final String LICENSED_CARD = "licensed card";
    private final List<ConfigPanel> configPanels = Lists.newArrayList();
    private EnabledConfigPanel enableControl;
    private JPanel compilationPane;
    private JPanel viewPane;
    private ContextFilterPane filterPane;
    private JTabbedPane tabbedPane;
    private JPanel licensedPane;
    private final Project project;
    private final IdeaCloverConfig ideaCloverConfig;
    public static final int COMPILATION_TAB_INDEX = 0;
    public static final int FILTER_TAB_INDEX = 2;

    public ProjectConfigPanel(Project proj, IdeaCloverConfig ideaCloverConfig) {
        this.project = proj;
        this.ideaCloverConfig = ideaCloverConfig;
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        CardLayout layout = new CardLayout();
        this.setLayout(layout);
        this.add((Component)this.getLicensedPanel(), LICENSED_CARD);
        layout.show(this, LICENSED_CARD);
        this.enableConfig(true);
    }

    private JPanel getLicensedPanel() {
        if (this.licensedPane == null) {
            this.licensedPane = new JPanel(new GridBagLayout());
            this.licensedPane.add((Component)this.getEnablePanel(), new GBC(1, 1).setFill(1).setWeight(1.0, 0.0).setAnchor(18));
            this.licensedPane.add((Component)this.getTabbedContent(), new GBC(1, 2).setFill(1).setWeight(1.0, 1.0));
            this.licensedPane.add((Component)new JPanel(), new GBC(1, 3).setFill(3).setWeight(0.0, 0.001));
        }
        return this.licensedPane;
    }

    private void initListeners() {
        this.getEnablePanel().getEnabledInput().addActionListener(this);
        this.ideaCloverConfig.addConfigChangeListener(this);
        this.getTabbedContent().getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProjectConfigPanel.this.ideaCloverConfig.setLastProjectConfigTabSelected(ProjectConfigPanel.this.getTabbedContent().getSelectedIndex());
            }
        });
    }

    private EnabledConfigPanel getEnablePanel() {
        if (this.enableControl == null) {
            this.enableControl = new EnabledConfigPanel();
        }
        return this.enableControl;
    }

    private JTabbedPane getTabbedContent() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(this.getCompilationPane().getName(), CloverIcons.COMPILE_ICON, this.getCompilationPane());
            this.tabbedPane.addTab(this.getViewPane().getName(), CloverIcons.VIEW_ICON, this.getViewPane());
            this.tabbedPane.addTab(this.getFilterPane().getName(), CloverIcons.FILTER_ICON, this.getFilterPane());
            int selectionHint = this.ideaCloverConfig.getLastProjectConfigTabSelected();
            if (selectionHint < 0 || selectionHint >= this.tabbedPane.getTabCount()) {
                Logger.getInstance((String)this.getClass().getName()).info("Invalid tab selection in the config [" + selectionHint + "], resetting.");
                selectionHint = 0;
                this.ideaCloverConfig.setLastProjectConfigTabSelected(selectionHint);
            }
            this.tabbedPane.setSelectedIndex(selectionHint);
        }
        return this.tabbedPane;
    }

    private JPanel getCompilationPane() {
        if (this.compilationPane == null) {
            this.compilationPane = new JPanel();
            this.compilationPane.setName("Compilation");
            GridBagLayout gb = new GridBagLayout();
            this.compilationPane.setLayout(gb);
            IdeaIDEContext context = new IdeaIDEContext(this.project);
            InitStringConfigPanel initStrPanel = new InitStringConfigPanel(context);
            this.compilationPane.add((Component)initStrPanel, new GBC(1, 1).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(initStrPanel);
            FlushPolicyConfigPanel flushPanel = new FlushPolicyConfigPanel();
            this.compilationPane.add((Component)flushPanel, new GBC(1, 2).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(flushPanel);
            InstrumentationConfigPanel filterPanel = new InstrumentationConfigPanel();
            this.compilationPane.add((Component)filterPanel, new GBC(2, 1).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(filterPanel);
            ProjectRebuildConfigPanel rebuildPanel = new ProjectRebuildConfigPanel();
            this.compilationPane.add((Component)rebuildPanel, new GBC(2, 2).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(rebuildPanel);
            this.compilationPane.add((Component)new JPanel(), new GBC(1, 3).setSpan(2, 1).setFill(1).setWeight(0.0, 1.0));
        }
        return this.compilationPane;
    }

    private JPanel getViewPane() {
        if (this.viewPane == null) {
            this.viewPane = new JPanel();
            this.viewPane.setName("View");
            GridBagLayout gb = new GridBagLayout();
            this.viewPane.setLayout(gb);
            RefreshPolicyConfigPanel refreshPanel = new RefreshPolicyConfigPanel();
            this.viewPane.add((Component)refreshPanel, new GBC(1, 1).setAnchor(18).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(refreshPanel);
            SpanConfigPanel spanConfigPanel = new SpanConfigPanel();
            this.viewPane.add((Component)spanConfigPanel, new GBC(1, 2).setAnchor(18).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(spanConfigPanel);
            GeneralConfigPanel generalPanel = new GeneralConfigPanel();
            this.viewPane.add((Component)generalPanel, new GBC(2, 1).setAnchor(18).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(generalPanel);
            PerTestLoadConfigPanel perTestDataPanel = new PerTestLoadConfigPanel();
            this.viewPane.add((Component)perTestDataPanel, new GBC(2, 2).setAnchor(18).setFill(1).setWeight(1.0, 0.0));
            this.configPanels.add(perTestDataPanel);
            SourceHighlightConfigPanel highlightPanel = new SourceHighlightConfigPanel();
            this.viewPane.add((Component)highlightPanel, new GBC(1, 3).setSpan(2, 1).setFill(2));
            this.configPanels.add(highlightPanel);
            this.viewPane.add((Component)new JPanel(), new GBC(1, 4).setSpan(2, 1).setFill(1).setWeight(0.0, 1.0));
        }
        return this.viewPane;
    }

    private JPanel getFilterPane() {
        if (this.filterPane == null) {
            this.filterPane = new ContextFilterPane(this.project);
            this.configPanels.add(this.filterPane);
        }
        return this.filterPane;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(650, 550);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void commitTo(IdeaCloverConfig config) {
        for (ConfigPanel configPanel : this.configPanels) {
            configPanel.commitTo(config);
        }
        this.enableControl.commitTo(config);
        config.notifyListeners();
    }

    public void loadFrom(IdeaCloverConfig config) {
        for (ConfigPanel configPanel : this.configPanels) {
            configPanel.loadFrom(config);
        }
        this.enableControl.loadFrom(config);
        this.enableConfig(config.isEnabled());
    }

    public void enableConfig(boolean b) {
        for (ConfigPanel configPanel : this.configPanels) {
            configPanel.enableConfig(b);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enableConfig(this.enableControl.getEnabledInput().isSelected());
    }

    public void cleanup() {
    }

    public static void main(String[] argv) {
        IdeaCloverConfig config = IdeaCloverConfig.fromProject(null);
        ProjectConfigPanel configPanel = new ProjectConfigPanel(null, null);
        configPanel.loadFrom(config);
        JFrame frame = new JFrame();
        frame.setSize(configPanel.getPreferredSize());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)configPanel, "Center");
        frame.validate();
        frame.setVisible(true);
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("enabled")) {
            ((CardLayout)this.getLayout()).show(this, LICENSED_CARD);
            this.loadFrom(this.ideaCloverConfig);
        }
    }
}

