/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.IDEContext;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.util.ui.UIUtils;
import com.atlassian.clover.util.FileUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class InitStringConfigPanel
extends ConfigPanel
implements ActionListener {
    private InitStringTextInput instInput;
    private JButton browseButton;
    private JTextArea helpText;
    private JRadioButton automaticButton;
    private JRadioButton manualButton;
    private JCheckBox relativeBox;
    private ButtonGroup buttonGroup;
    private IDEContext context;

    public InitStringConfigPanel(IDEContext ctx) {
        this.context = ctx;
        this.initLayout();
        this.initListeners();
        this.refreshState();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.add((Component)this.getHelpText(), new GBC(1, 1).setInsets(0, 6, 10, 6).setSpan(3, 1).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)this.getAutomaticButton(), new GBC(1, 2).setInsets(0, 6, 0, 6).setSpan(2, 1).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)this.getManualButton(), new GBC(1, 3).setInsets(0, 6, 0, 6).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)this.getInitStrInput(), new GBC(1, 4).setInsets(0, 6, 0, 0).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)this.getBrowseButton(), new GBC(2, 4).setInsets(0, 0, 0, 6).setAnchor(17).setWeight(1.0, 1.0));
        this.add((Component)this.getRelativeCheckBox(), new GBC(1, 5).setSpan(2, 1).setInsets(0, 6, 6, 6).setFill(2).setWeight(1.0, 1.0));
        this.add((Component)new JPanel(), new GBC(1, 6).setSpan(2, 1).setFill(1).setWeight(0.0, 1.0));
    }

    private void initListeners() {
        this.getBrowseButton().addActionListener(this);
        this.getAutomaticButton().addActionListener(this);
        this.getManualButton().addActionListener(this);
        this.getRelativeCheckBox().addActionListener(this);
    }

    @Override
    public String getTitle() {
        return "InitString";
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("The Initstring specifies the name of the coverage database file. Select 'Automatic' to have Clover manage this location for you.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private InitStringTextInput getInitStrInput() {
        if (this.instInput == null) {
            this.instInput = new InitStringTextInput();
            this.instInput.setColumns(20);
        }
        return this.instInput;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton();
            this.browseButton.setText("...");
        }
        return this.browseButton;
    }

    private JRadioButton getAutomaticButton() {
        if (this.automaticButton == null) {
            this.automaticButton = new JRadioButton("Automatic");
            this.getButtonGroup().add(this.automaticButton);
        }
        return this.automaticButton;
    }

    private JRadioButton getManualButton() {
        if (this.manualButton == null) {
            this.manualButton = new JRadioButton("User specified:");
            this.getButtonGroup().add(this.manualButton);
            this.manualButton.setSelected(true);
        }
        return this.manualButton;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    private JCheckBox getRelativeCheckBox() {
        if (this.relativeBox == null) {
            this.relativeBox = new JCheckBox("relative to project directory.");
        }
        return this.relativeBox;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getBrowseButton()) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            boolean relativeToProjectBase = this.getRelativeCheckBox().isSelected();
            if (relativeToProjectBase) {
                try {
                    File dir = this.context.getProjectRootDirectory();
                    if (dir != null) {
                        chooser.setCurrentDirectory(dir);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ((returnVal = chooser.showOpenDialog(this)) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.getInitStrInput().setInitStr(selectedFile);
            }
        } else if (evt.getSource() == this.getAutomaticButton() || evt.getSource() == this.getManualButton()) {
            this.refreshState();
        } else if (evt.getSource() == this.getRelativeCheckBox()) {
            this.getInitStrInput().setRelativeToProjectDir(this.getRelativeCheckBox().isSelected());
        }
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        config.setManualInitString(this.getInitStrInput().getInitStr());
        config.setUseGeneratedInitString(this.getAutomaticButton().isSelected());
        config.setRelativeInitString(this.getRelativeCheckBox().isSelected());
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        this.getAutomaticButton().setSelected(config.getUseGeneratedInitString());
        this.getRelativeCheckBox().setSelected(config.isRelativeInitString());
        this.getInitStrInput().setRelativeToProjectDir(config.isRelativeInitString());
        this.getInitStrInput().setInitStr(config.getManualInitString());
        this.refreshState();
    }

    @Override
    public void enableConfig(boolean b) {
        if (b) {
            this.setBorder(this.getEnabledBorder());
        } else {
            this.setBorder(this.getDisabledBorder());
        }
        this.getHelpText().setEnabled(b);
        this.getAutomaticButton().setEnabled(b);
        this.getManualButton().setEnabled(b);
        if (b) {
            this.refreshState();
        } else {
            this.getInitStrInput().setEnabled(false);
            this.getBrowseButton().setEnabled(false);
            this.getRelativeCheckBox().setEnabled(false);
        }
    }

    private void refreshState() {
        if (this.getAutomaticButton().isSelected()) {
            this.getInitStrInput().setEnabled(false);
            this.getBrowseButton().setEnabled(false);
            this.getRelativeCheckBox().setEnabled(false);
        } else {
            this.getInitStrInput().setEnabled(true);
            this.getBrowseButton().setEnabled(true);
            this.getRelativeCheckBox().setEnabled(true);
        }
    }

    private class InitStringTextInput
    extends JTextField {
        private boolean isRelative;

        private InitStringTextInput() {
        }

        public void setRelativeToProjectDir(boolean b) {
            if (b == this.isRelative) {
                return;
            }
            String initStr = this.getInitStr();
            this.isRelative = b;
            this.setInitStr(initStr);
        }

        public boolean isRelativeToProjectDir() {
            return this.isRelative;
        }

        public void setInitStr(File f) {
            this.setInitStr(f.getAbsolutePath());
        }

        public void setInitStr(String s) {
            String text = null;
            if (s != null) {
                text = this.isRelativeToProjectDir() ? FileUtils.getRelativePath(InitStringConfigPanel.this.context.getProjectRootDirectory().getAbsolutePath(), s) : s;
            }
            this.setText(text);
        }

        public String getInitStr() {
            String text = this.getText();
            if (text == null || text.trim().length() == 0) {
                return null;
            }
            File initStr = this.isRelativeToProjectDir() ? new File(InitStringConfigPanel.this.context.getProjectRootDirectory(), text) : new File(text);
            return initStr.getAbsolutePath();
        }
    }
}

