/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.util.ui.UIUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FlushPolicyConfigPanel
extends ConfigPanel
implements ActionListener {
    private JTextArea helpText;
    private JRadioButton directedButton;
    private JRadioButton intervalButton;
    private JRadioButton threadedButton;
    private ButtonGroup buttonGroup;
    private JLabel intervalLabelA;
    private JTextField intervalField;
    private JLabel intervalLabelB;

    public FlushPolicyConfigPanel() {
        this.initLayout();
        this.initListeners();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.add((Component)this.getHelpText(), new GBC(1, 1).setInsets(0, 6, 10, 6).setSpan(3, 1).setFill(2));
        this.add((Component)this.getDirectedButton(), new GBC(1, 2).setInsets(0, 6, 0, 6).setFill(2));
        this.add((Component)this.getIntervalButton(), new GBC(1, 3).setInsets(0, 6, 0, 0).setFill(2));
        this.add((Component)this.getPreIntervalInputLabel(), new GBC(2, 3).setInsets(0, 0, 0, 6).setSpan(2, 1).setAnchor(17).setWeight(1.0, 0.0));
        this.add((Component)this.getThreadedButton(), new GBC(1, 4).setInsets(0, 6, 6, 0).setFill(2));
        this.add((Component)this.getIntervalInput(), new GBC(2, 4).setInsets(0, 0, 6, 0).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)this.getPostIntervalInputLabel(), new GBC(3, 4).setInsets(0, 0, 6, 6).setFill(2));
    }

    private void initListeners() {
        this.getDirectedButton().addActionListener(this);
        this.getIntervalButton().addActionListener(this);
        this.getThreadedButton().addActionListener(this);
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        if (this.getDirectedButton().isSelected()) {
            config.setFlushPolicy(0);
        } else if (this.getIntervalButton().isSelected()) {
            config.setFlushPolicy(1);
        } else if (this.getThreadedButton().isSelected()) {
            config.setFlushPolicy(2);
        }
        String interval = this.getIntervalInput().getText();
        try {
            config.setFlushInterval(Integer.parseInt(interval));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        switch (config.getFlushPolicy()) {
            case 1: {
                this.getIntervalButton().setSelected(true);
                break;
            }
            case 2: {
                this.getThreadedButton().setSelected(true);
                break;
            }
            default: {
                this.getDirectedButton().setSelected(true);
            }
        }
        this.getIntervalInput().setText("" + config.getFlushInterval());
        this.refreshState();
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("The Flush Policy controls how Clover writes coverage data to disk at runtime.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JRadioButton getDirectedButton() {
        if (this.directedButton == null) {
            this.directedButton = new JRadioButton("Directed");
            this.getButtonGroup().add(this.directedButton);
            this.directedButton.setSelected(true);
        }
        return this.directedButton;
    }

    private JRadioButton getIntervalButton() {
        if (this.intervalButton == null) {
            this.intervalButton = new JRadioButton("Interval");
            this.getButtonGroup().add(this.intervalButton);
        }
        return this.intervalButton;
    }

    private JRadioButton getThreadedButton() {
        if (this.threadedButton == null) {
            this.threadedButton = new JRadioButton("Threaded     ");
            this.getButtonGroup().add(this.threadedButton);
        }
        return this.threadedButton;
    }

    private JLabel getPreIntervalInputLabel() {
        if (this.intervalLabelA == null) {
            this.intervalLabelA = new JLabel("Flush interval");
        }
        return this.intervalLabelA;
    }

    private JLabel getPostIntervalInputLabel() {
        if (this.intervalLabelB == null) {
            this.intervalLabelB = new JLabel(" msecs");
        }
        return this.intervalLabelB;
    }

    private JTextField getIntervalInput() {
        if (this.intervalField == null) {
            this.intervalField = new JTextField();
            this.intervalField.setColumns(6);
        }
        return this.intervalField;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    @Override
    public String getTitle() {
        return "Flush Policy";
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.getDirectedButton() || evt.getSource() == this.getIntervalButton() || evt.getSource() == this.getThreadedButton()) {
            this.refreshState();
        }
    }

    @Override
    public void enableConfig(boolean b) {
        if (b) {
            this.setBorder(this.getEnabledBorder());
        } else {
            this.setBorder(this.getDisabledBorder());
        }
        this.getHelpText().setEnabled(b);
        this.getDirectedButton().setEnabled(b);
        this.getIntervalButton().setEnabled(b);
        this.getIntervalInput().setEnabled(b);
        this.getPreIntervalInputLabel().setEnabled(b);
        this.getPostIntervalInputLabel().setEnabled(b);
        this.getThreadedButton().setEnabled(b);
        this.setEnabled(b);
        if (b) {
            this.refreshState();
        }
    }

    private void refreshState() {
        if (this.getDirectedButton().isSelected()) {
            this.getIntervalInput().setEnabled(false);
            this.getPreIntervalInputLabel().setEnabled(false);
            this.getPostIntervalInputLabel().setEnabled(false);
        } else if (this.getIntervalButton().isSelected()) {
            this.getIntervalInput().setEnabled(true);
            this.getPreIntervalInputLabel().setEnabled(true);
            this.getPostIntervalInputLabel().setEnabled(true);
        } else if (this.getThreadedButton().isSelected()) {
            this.getIntervalInput().setEnabled(true);
            this.getPreIntervalInputLabel().setEnabled(true);
            this.getPostIntervalInputLabel().setEnabled(true);
        }
    }
}

