/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.ContextPane;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.IdeaRegexpConfigPanel;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class ContextFilterPane
extends ConfigPanel {
    private final ContextPane reservedContexts;
    private final IdeaRegexpConfigPanel regexpPanel;

    public ContextFilterPane(Project project) {
        ContextStore registry;
        CloverDatabase cloverDatabase = ProjectPlugin.getPlugin(project).getCoverageManager().getCoverage();
        ContextStore contextStore = registry = cloverDatabase != null ? cloverDatabase.getContextStore() : null;
        if (registry == null) {
            registry = new ContextStore();
        }
        this.setName("Contexts");
        this.setLayout(new GridBagLayout());
        this.reservedContexts = new ContextPane(registry);
        this.add((Component)this.reservedContexts, new GBC(1, 1).setFill(2).setWeight(0.01, 0.0));
        this.regexpPanel = new IdeaRegexpConfigPanel(project, registry);
        this.add((Component)this.regexpPanel, new GBC(1, 2).setFill(2).setWeight(0.01, 1.0));
        this.add((Component)new JPanel(), new GBC(1, 3).setFill(1).setWeight(0.0, 1.0));
    }

    @Override
    public void commitTo(CloverPluginConfig data) {
        this.reservedContexts.commitTo(data);
        this.regexpPanel.commitTo(data);
    }

    @Override
    public void loadFrom(CloverPluginConfig data) {
        this.reservedContexts.loadFrom(data);
        this.regexpPanel.loadFrom(data);
    }

    @Override
    public String getTitle() {
        return "Context Filters";
    }

    @Override
    public void enableConfig(boolean b) {
        this.reservedContexts.enableConfig(b);
        this.regexpPanel.enableConfig(b);
    }
}

