/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.autoupdater.AutoUpdateComponent;
import com.atlassian.clover.idea.autoupdater.AutoUpdateConfiguration;
import com.atlassian.clover.idea.autoupdater.NewVersionNotifier;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class AutoUpdateConfigPanel
extends JPanel {
    private final JCheckBox autoUpdate = new JCheckBox(CloverIdeaPluginMessages.getString("autoupdate.auto"));

    public AutoUpdateConfigPanel() {
        this.setLayout(new GridBagLayout());
        VerticalBox box = new VerticalBox();
        box.setBorder((Border)BorderFactory.createTitledBorder(CloverIdeaPluginMessages.getString("autoupdate.configtitle")));
        box.add((Component)this.autoUpdate);
        HorizontalBox buttons = new HorizontalBox();
        JButton checkNow = new JButton(CloverIdeaPluginMessages.getString("autoupdate.checknow"));
        JButton downloadManually = new JButton(CloverIdeaPluginMessages.getString("autoupdate.fromurl"));
        buttons.add((Component)checkNow);
        buttons.add((Component)downloadManually);
        box.add((Component)buttons);
        this.add((Component)box, new GBC(0, 0).setWeight(1.0, 0.0).setFill(1));
        this.add((Component)new JPanel(), new GBC(0, 1).setWeight(1.0, 1.0).setFill(1));
        checkNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVersionNotifier notifier = AutoUpdateConfigPanel.this.getAnyNotifier();
                if (notifier != null) {
                    notifier.checkNow();
                }
            }
        });
        downloadManually.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = Messages.showInputDialog((String)CloverIdeaPluginMessages.getString("autoupdate.enterurl"), (String)CloverIdeaPluginMessages.getString("autoupdate.updatingplugin"), (Icon)CloverIcons.CLOVER_BIG);
                if (url != null) {
                    AutoUpdateComponent.getInstance().performUpdate(url);
                }
            }
        });
    }

    private NewVersionNotifier getAnyNotifier() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Project anyProject = openProjects.length > 0 ? openProjects[0] : ProjectManager.getInstance().getDefaultProject();
        NewVersionNotifier notifier = NewVersionNotifier.getInstance(anyProject);
        return notifier;
    }

    public void setAutoUpdateConfig(AutoUpdateConfiguration config) {
        this.autoUpdate.setSelected(config.isAutoUpdate());
    }

    public AutoUpdateConfiguration getAutoUpdateConfig() {
        return new AutoUpdateConfiguration(this.autoUpdate.isSelected());
    }
}

