/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.idea.build.jps.CloverJpsProjectConfigurationSerializer;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.util.trie.FilePathPrefixTree;
import com.atlassian.clover.util.trie.Node;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsModelUtil {
    public static boolean isBuildWithCloverEnabled(@NotNull JpsProject jpsProject) {
        CloverPluginConfig data = JpsModelUtil.getCloverPluginConfig(jpsProject);
        return data != null && data.isBuildWithClover();
    }

    public static boolean isCloverEnabled(@NotNull JpsProject jpsProject) {
        CloverPluginConfig data = JpsModelUtil.getCloverPluginConfig(jpsProject);
        return data != null && data.isEnabled();
    }

    public static boolean isDumpInstrumentedSources(@NotNull JpsProject jpsProject) {
        CloverPluginConfig data = JpsModelUtil.getCloverPluginConfig(jpsProject);
        return data != null && data.isDumpInstrumentedSources();
    }

    @Nullable
    public static CloverPluginConfig getCloverPluginConfig(@NotNull JpsProject jpsProject) {
        JpsSimpleElement child = (JpsSimpleElement)jpsProject.getContainer().getChild((JpsElementChildRole)CloverJpsProjectConfigurationSerializer.CloverProjectConfigurationRole.INSTANCE);
        return child != null ? (CloverPluginConfig)child.getData() : null;
    }

    @Nullable
    public static JpsModuleSourceRoot findSourceRootForFile(@NotNull JpsModule module, @NotNull File sourceFile) {
        FilePathPrefixTree<Boolean> excludedRootsTree = new FilePathPrefixTree<Boolean>(Boolean.FALSE);
        for (File file : JpsModelUtil.getExcludedRoots(module)) {
            excludedRootsTree.add(file, Boolean.TRUE);
        }
        if (excludedRootsTree.findNearest(sourceFile).getValue() == Boolean.TRUE) {
            return null;
        }
        FilePathPrefixTree<JpsModuleSourceRoot> sourceRootsTree = new FilePathPrefixTree<JpsModuleSourceRoot>();
        for (JpsModuleSourceRoot sourceRoot : module.getSourceRoots()) {
            sourceRootsTree.add(sourceRoot.getFile(), sourceRoot);
        }
        Node node = sourceRootsTree.findNearestWithValue(sourceFile);
        return node != null ? (JpsModuleSourceRoot)node.getValue() : null;
    }

    @Nullable
    public static JpsModule findModuleForFile(JpsProject project, File sourceFile) {
        FilePathPrefixTree<JpsModule> ancestorModules = new FilePathPrefixTree<JpsModule>();
        for (JpsModule jpsModule : project.getModules()) {
            JpsModuleSourceRoot sourceRoot = JpsModelUtil.findSourceRootForFile(jpsModule, sourceFile);
            if (sourceRoot == null) continue;
            ancestorModules.add(sourceRoot.getFile(), jpsModule);
        }
        Node closestModule = ancestorModules.findNearestWithValue(sourceFile);
        return closestModule != null ? (JpsModule)closestModule.getValue() : null;
    }

    public static Set<File> getExcludedRoots(JpsModule jpsModule) {
        JpsUrlList excludedRootsAsUrls = jpsModule.getExcludeRootsList();
        HashSet<File> excludedRootsAsFiles = new HashSet<File>(excludedRootsAsUrls.getUrls().size());
        for (String url : excludedRootsAsUrls.getUrls()) {
            excludedRootsAsFiles.add(JpsPathUtil.urlToFile((String)url));
        }
        return excludedRootsAsFiles;
    }
}

