/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import clover.antlr.RecognitionException;
import clover.antlr.TokenStreamException;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.java.SourceLevel;
import com.atlassian.clover.idea.build.InclusionDetector;
import com.atlassian.clover.idea.build.jps.CloverInstrumentationException;
import com.atlassian.clover.idea.build.jps.CloverJavaBuilder;
import com.atlassian.clover.idea.build.jps.JpsModelUtil;
import com.atlassian.clover.idea.build.jps.JpsProjectInclusionDetector;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.util.trie.Node;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.LanguageLevel;

public class CloverJavaSourceTransformer
extends JavaSourceTransformer {
    private final Logger LOG = Logger.getInstance((String)CloverJavaSourceTransformer.class.getName());
    private JpsProject jpsProject;
    protected static final Map<LanguageLevel, SourceLevel> LANGUAGE_LEVEL_TO_SOURCE_LEVEL = new HashMap<LanguageLevel, SourceLevel>(){
        {
            this.put(LanguageLevel.JDK_1_9, SourceLevel.JAVA_9);
            this.put(LanguageLevel.JDK_1_8, SourceLevel.JAVA_8);
            this.put(LanguageLevel.JDK_1_7, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_6, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_5, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_4, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_3, SourceLevel.JAVA_7);
        }
    };

    public boolean isTransformable(@NotNull File file) throws JavaSourceTransformer.TransformError {
        this.LOG.debug("isTransformable: " + file);
        if (!JpsModelUtil.isBuildWithCloverEnabled(this.jpsProject)) {
            return false;
        }
        InclusionDetector inclusion = JpsProjectInclusionDetector.processFile(this.jpsProject, file);
        if (inclusion.isCloverDisabled()) {
            this.LOG.debug("Instrumentation is disabled");
            return false;
        }
        if (inclusion.isNotJava()) {
            this.LOG.debug("Ignoring non-java file: " + file);
            return false;
        }
        if (inclusion.isModuleExcluded()) {
            this.LOG.debug("File belongs to excluded module: " + file);
            return false;
        }
        if (inclusion.isPatternExcluded()) {
            this.LOG.debug("Ignoring excluded file: " + file);
            return false;
        }
        if (inclusion.isInNoninstrumentedTestSources()) {
            this.LOG.debug("Ignoring marked test case: " + file);
            return false;
        }
        return inclusion.isIncluded();
    }

    public CharSequence transform(File file, CharSequence charSequence) throws JavaSourceTransformer.TransformError {
        this.jpsProject = CloverJavaBuilder.getInstance().getCompileContext().getProjectDescriptor().getProject();
        if (this.isTransformable(file)) {
            try {
                LanguageLevel level = this.getLanguageLevelForFile(file);
                Instrumenter instrumenter = CloverJavaBuilder.getInstance().getInstrumenter();
                SourceLevel sourceLevel = this.languageLevelToSourceLevel(level);
                instrumenter.getConfig().setSourceLevel(sourceLevel);
                JpsEncodingProjectConfiguration projectEncodingConfiguration = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(this.jpsProject);
                String fileEncoding = projectEncodingConfiguration != null ? projectEncodingConfiguration.getEncoding(file) : null;
                CharSequence instrumentedCharSequence = instrumenter.instrument(file, charSequence, fileEncoding);
                String message = "Clover: instrumenting " + file.getName() + " with source level " + (Object)((Object)sourceLevel);
                CloverJavaBuilder.getInstance().sendCompilerMessageToIDE(BuildMessage.Kind.PROGRESS, message);
                this.debugTransform(file, charSequence, instrumentedCharSequence, level);
                return instrumentedCharSequence;
            }
            catch (RecognitionException | TokenStreamException | CloverException | IOException ex) {
                throw new CloverInstrumentationException(ex);
            }
        }
        this.LOG.info("CloverSourceTransformer.transform skipping file " + file);
        return charSequence;
    }

    public LanguageLevel getLanguageLevelForFile(File sourceFile) {
        Node<String, LanguageLevel> closestSourceRoot = CloverJavaBuilder.getInstance().getSourceRootToLanguageLevel().findNearest(sourceFile);
        return closestSourceRoot.getValue() != null ? closestSourceRoot.getValue() : LanguageLevel.JDK_1_9;
    }

    public SourceLevel languageLevelToSourceLevel(LanguageLevel level) {
        SourceLevel sourceLevel = LANGUAGE_LEVEL_TO_SOURCE_LEVEL.get(level);
        return sourceLevel == null ? SourceLevel.JAVA_9 : sourceLevel;
    }

    private void debugTransform(File file, CharSequence charSequence, CharSequence instrCharSequence, LanguageLevel level) {
        if (JpsModelUtil.isDumpInstrumentedSources(this.jpsProject)) {
            String tmpDir;
            String message = "CloverSourceTransformer.transform(" + file.getAbsolutePath() + ", with " + charSequence.length() + "characters) called; language level=" + level;
            this.LOG.debug(message);
            try {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            catch (SecurityException ex) {
                tmpDir = null;
            }
            if (tmpDir != null) {
                this.writeCharSequenceToFile(new File(tmpDir, file.getName() + ".orig"), charSequence);
                this.writeCharSequenceToFile(new File(tmpDir, file.getName() + ".instr"), instrCharSequence);
            } else {
                this.LOG.debug("Unable to read java.io.tmpdir property. Temporary files with instrumented code will not be written.");
            }
        }
    }

    private void writeCharSequenceToFile(File file, CharSequence charSequence) {
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(file));
            ((Writer)out).append(charSequence);
            ((Writer)out).close();
        }
        catch (IOException ex) {
            this.LOG.debug("Unable to write temporary file: " + ex.getMessage());
        }
    }
}

