/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.SourceLevel;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.RegexpContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.idea.build.jps.JpsModelUtil;
import com.atlassian.clover.idea.build.jps.JpsProjectPrefixTreeUtil;
import com.atlassian.clover.idea.build.jps.JpsProjectTestDetector;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.util.trie.FilePathPrefixTree;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.module.JpsModule;

public class CloverJavaBuilder
extends ModuleLevelBuilder {
    private static final CloverJavaBuilder INSTANCE = new CloverJavaBuilder();
    private final Logger LOG = Logger.getInstance((String)CloverJavaBuilder.class.getName());
    private volatile CompileContext compileContext;
    private volatile FilePathPrefixTree<LanguageLevel> sourceRootToLanguageLevel;
    private Instrumenter instr;

    public static CloverJavaBuilder getInstance() {
        return INSTANCE;
    }

    private CloverJavaBuilder() {
        super(BuilderCategory.SOURCE_INSTRUMENTER);
    }

    @NotNull
    public String getPresentableName() {
        return "clover-java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(CompileContext context) {
        super.buildStarted(context);
        CloverJavaBuilder cloverJavaBuilder = this;
        synchronized (cloverJavaBuilder) {
            this.sourceRootToLanguageLevel = JpsProjectPrefixTreeUtil.collectLanguageLevels(context.getProjectDescriptor().getProject());
            this.compileContext = context;
            this.instr = this.createInstrumenter();
        }
        this.LOG.info("CloverJavaBuilder.buildStarted called. context=" + context);
        this.sendCompilerMessageToIDE(BuildMessage.Kind.INFO, "CloverJavaBuilder external build starts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(CompileContext context) {
        super.buildFinished(context);
        this.LOG.info("CloverJavaBuilder.buildFinished called. context=" + context);
        this.sendCompilerMessageToIDE(BuildMessage.Kind.PROGRESS, "CloverJavaBuilder build is finished");
        CloverJavaBuilder cloverJavaBuilder = this;
        synchronized (cloverJavaBuilder) {
            this.closeInstrumentationSession();
            this.compileContext = null;
        }
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        this.LOG.info("CloverJavaBuilder.build called. context=" + context + " chunk=" + chunk + " dirtyFilesHolder=" + dirtyFilesHolder + " outputConsumer=" + outputConsumer);
        String msg = "CloverJavaBuilder processing module chunk " + chunk.getName() + " with modules: ";
        for (JpsModule module : chunk.getModules()) {
            msg = msg + module.getName() + ",";
        }
        this.sendCompilerMessageToIDE(BuildMessage.Kind.PROGRESS, msg);
        return ModuleLevelBuilder.ExitCode.OK;
    }

    public List<String> getCompilableFileExtensions() {
        ArrayList<String> extensionWithoutDot = new ArrayList<String>(Language.Builtin.JAVA.getFileExtensions().size());
        for (String ext : Language.Builtin.JAVA.getFileExtensions()) {
            extensionWithoutDot.add(ext.substring(1));
        }
        return extensionWithoutDot;
    }

    public CompileContext getCompileContext() {
        return this.compileContext;
    }

    public FilePathPrefixTree<LanguageLevel> getSourceRootToLanguageLevel() {
        return this.sourceRootToLanguageLevel;
    }

    public Instrumenter getInstrumenter() {
        return this.instr;
    }

    protected void sendErrorNotification(String message) {
        this.sendCompilerMessageToIDE(BuildMessage.Kind.ERROR, message);
        this.LOG.error(message);
    }

    protected synchronized void sendCompilerMessageToIDE(BuildMessage.Kind kind, String message) {
        if (this.compileContext != null) {
            this.compileContext.processMessage((BuildMessage)new CompilerMessage("", kind, message));
        }
    }

    private JavaInstrumentationConfig createInstrumentationConfig(CloverPluginConfig config, JpsProject project) {
        JavaInstrumentationConfig instrConfig = new JavaInstrumentationConfig();
        instrConfig.setInitstring(config.getInitString());
        instrConfig.setFlushPolicy(config.getFlushPolicy());
        instrConfig.setFlushInterval(config.getFlushInterval());
        instrConfig.setSourceLevel(SourceLevel.fromString(config.getLanguageLevel()));
        instrConfig.setTestDetector(new JpsProjectTestDetector(project, JpsProjectPrefixTreeUtil.collectRootTypes(project)));
        instrConfig.setInstrumentLambda(config.getInstrumentLambda());
        return instrConfig;
    }

    private Instrumenter createInstrumenter() {
        if (!this.isCloverInstrumentationEnabled()) {
            return null;
        }
        if (this.instr == null) {
            Clover2Registry registry;
            CloverPluginConfig pluginConfig = JpsModelUtil.getCloverPluginConfig(this.compileContext.getProjectDescriptor().getProject());
            if (pluginConfig == null) {
                this.sendErrorNotification("Clover was unable to find its configuration data associated with the current project");
                return null;
            }
            JavaInstrumentationConfig instrConfig = this.createInstrumentationConfig(pluginConfig, this.compileContext.getProjectDescriptor().getProject());
            Instrumenter instrumenter = new Instrumenter(instrConfig);
            try {
                registry = Clover2Registry.createOrLoad(new File(instrConfig.getInitString()), instrConfig.getProjectName());
            }
            catch (CloverException | IOException ex) {
                this.sendErrorNotification("Clover was unable to instrument your source because of the following error:" + ex + ". Please try to delete the coverage database run build again.");
                return null;
            }
            List<Regexp> regexpCtxList = pluginConfig.getRegexpContexts();
            if (regexpCtxList != null) {
                try {
                    ContextStore contextRegistry = new ContextStore();
                    for (Regexp regexp : regexpCtxList) {
                        if (!regexp.isValid()) continue;
                        RegexpContext regexpContext = regexp.toContextSetting();
                        if (regexpContext instanceof MethodRegexpContext) {
                            contextRegistry.addMethodContext((MethodRegexpContext)regexpContext);
                            continue;
                        }
                        contextRegistry.addStatementContext((StatementRegexpContext)regexpContext);
                    }
                    registry.setContextStore(contextRegistry);
                }
                catch (CloverException ex) {
                    String msg = "Clover was unable to process method or statement context regular expressions. See IDEA log for more details.";
                    this.sendCompilerMessageToIDE(BuildMessage.Kind.ERROR, "Clover was unable to process method or statement context regular expressions. See IDEA log for more details.");
                    this.LOG.error("Clover was unable to process method or statement context regular expressions. See IDEA log for more details.", (Throwable)ex);
                    return null;
                }
            }
            try {
                instrumenter.startInstrumentation(registry);
            }
            catch (CloverException ex) {
                String msg = "Clover was unable to start new instrumentation session. See IDEA log for more details.";
                this.LOG.error("Clover was unable to start new instrumentation session. See IDEA log for more details.", (Throwable)ex);
                this.sendCompilerMessageToIDE(BuildMessage.Kind.ERROR, "Clover was unable to start new instrumentation session. See IDEA log for more details.");
                return null;
            }
            this.instr = instrumenter;
        }
        return this.instr;
    }

    private boolean isCloverInstrumentationEnabled() {
        return JpsModelUtil.isBuildWithCloverEnabled(this.compileContext.getProjectDescriptor().getProject()) && JpsModelUtil.isCloverEnabled(this.compileContext.getProjectDescriptor().getProject());
    }

    private void closeInstrumentationSession() {
        if (!this.isCloverInstrumentationEnabled()) {
            return;
        }
        if (this.instr != null) {
            try {
                this.instr.endInstrumentation(true);
                this.instr = null;
                this.LOG.info("completed instrumentation.");
            }
            catch (CloverException ex) {
                this.LOG.error((Throwable)ex);
            }
        }
    }
}

