/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class RebuildProjectDialog
extends DialogWrapper {
    private static final String TITLE = "Project rebuild required";
    private static final String TITLE_CLEAN = "Project rebuild with Clover database cleaned required";
    private static final String DESCRIPTION = "<html>Clover settings change requires project rebuild.";
    private static final String DESCRIPTION_CLEAN = "<html>Clover settings change requires Clover database cleanup and project rebuild.";
    private final String description;
    private final JCheckBox askNextTime = new JCheckBox("Prompt me again when rebuild is required", true);
    private final AbstractAction skipAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RebuildProjectDialog.this.close(1);
        }
    };

    public RebuildProjectDialog(Project project, boolean cleanDb) {
        super(project, false);
        this.description = cleanDb ? DESCRIPTION_CLEAN : DESCRIPTION;
        this.setTitle(cleanDb ? TITLE_CLEAN : TITLE);
        this.setOKButtonText(cleanDb ? "Clean and rebuild now" : "Rebuild now");
        this.setSkipButtonText("Skip rebuild");
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.skipAction};
    }

    private void setSkipButtonText(String text) {
        this.skipAction.putValue("Name", text);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, 15dlu, pref:g, 3dlu", "3dlu, pref, 9dlu, pref:g, 3dlu");
        CellConstraints iconCC = new CellConstraints(2, 2, 1, 3);
        CellConstraints descrCC = new CellConstraints(4, 2, 2, 1);
        CellConstraints choiceCC = new CellConstraints(5, 4, 1, 1);
        JPanel thePanel = new JPanel((LayoutManager)formLayout);
        JLabel iconLabel = new JLabel(Messages.getWarningIcon());
        iconLabel.setVerticalAlignment(1);
        thePanel.add((Component)iconLabel, iconCC);
        thePanel.add((Component)new JLabel(this.description), descrCC);
        thePanel.add((Component)this.askNextTime, choiceCC);
        return thePanel;
    }

    public boolean rebuildRequested() {
        return this.getExitCode() == 0;
    }

    public boolean askNextTime() {
        return this.askNextTime.isSelected();
    }
}

