/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.CloverDependencyProcessingItem;
import com.atlassian.clover.idea.build.CloverValidityState;
import com.atlassian.clover.idea.build.ProjectInclusionDetector;
import com.atlassian.clover.idea.util.MiscUtils;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DependencyInjectingCompiler
implements SourceInstrumentingCompiler {
    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        final VirtualFile[] files = context.getCompileScope().getFiles((FileType)StdFileTypes.JAVA, true);
        final FileProcessingCompiler.ProcessingItem[] items = new FileProcessingCompiler.ProcessingItem[files.length];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < files.length; ++i) {
                    VirtualFile file = files[i];
                    boolean included = ProjectInclusionDetector.processFile(context.getProject(), file).isIncluded();
                    items[i] = new CloverDependencyProcessingItem(file, new CloverValidityState(included));
                }
            }
        });
        return items;
    }

    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        if (this.isClassicBuild(context.getProject())) {
            return this.processForClassicBuild(context, items);
        }
        return this.processForExternalBuild(context, items);
    }

    protected FileProcessingCompiler.ProcessingItem[] processForClassicBuild(final CompileContext context, final FileProcessingCompiler.ProcessingItem[] items) {
        final ArrayList toDelete = new ArrayList(items.length * 2);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (FileProcessingCompiler.ProcessingItem item : items) {
                    VirtualFile vf = item.getFile();
                    PsiFile file = PsiManager.getInstance((Project)context.getProject()).findFile(vf);
                    if (!(file instanceof PsiJavaFile)) continue;
                    Module m = context.getModuleByFile(vf);
                    PsiJavaFile pjf = (PsiJavaFile)file;
                    VirtualFile outputDirectory = context.getModuleOutputDirectory(m);
                    VirtualFile outputTestDirectory = context.getModuleOutputDirectoryForTests(m);
                    for (PsiClass psiClass : pjf.getClasses()) {
                        VirtualFile classFile;
                        String name = psiClass.getQualifiedName();
                        if (name == null) continue;
                        String path = name.replace('.', '/') + ".class";
                        if (outputDirectory != null && (classFile = outputDirectory.findFileByRelativePath(path)) != null) {
                            toDelete.add(classFile);
                        }
                        if (outputTestDirectory == null || (classFile = outputTestDirectory.findFileByRelativePath(path)) == null) continue;
                        toDelete.add(classFile);
                    }
                }
            }
        });
        MiscUtils.invokeWriteActionAndWait(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : toDelete) {
                    try {
                        file.delete((Object)DependencyInjectingCompiler.this);
                    }
                    catch (IOException e) {
                        Logger.getInstance().info("Cannot delete output file " + file, e);
                    }
                }
            }
        });
        return items;
    }

    protected FileProcessingCompiler.ProcessingItem[] processForExternalBuild(final CompileContext context, final FileProcessingCompiler.ProcessingItem[] items) {
        final ArrayList toTouch = new ArrayList(items.length);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (FileProcessingCompiler.ProcessingItem item : items) {
                    VirtualFile vf = item.getFile();
                    PsiFile file = PsiManager.getInstance((Project)context.getProject()).findFile(vf);
                    if (!(file instanceof PsiJavaFile)) continue;
                    toTouch.add(vf);
                }
            }
        });
        MiscUtils.invokeWriteActionAndWait(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : toTouch) {
                    file.refresh(false, false);
                }
            }
        });
        return items;
    }

    private boolean isClassicBuild(Project project) {
        try {
            Method useOutOfProcessBuild = CompilerWorkspaceConfiguration.class.getMethod("useOutOfProcessBuild", new Class[0]);
            Object ret = useOutOfProcessBuild.invoke((Object)CompilerWorkspaceConfiguration.getInstance((Project)project), new Object[0]);
            return (Boolean)ret == false;
        }
        catch (Exception ex) {
            Logger.getInstance().debug("Exception caught when trying to check if external build is enabled. Assuming that an external build is used. ", ex);
            return false;
        }
    }

    @NotNull
    public String getDescription() {
        return "Clover dependency injecting compiler";
    }

    public boolean validateConfiguration(CompileScope scope) {
        Module[] modules = scope.getAffectedModules();
        return modules.length > 0 && ProjectPlugin.getPlugin(modules[0].getProject()) != null;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return CloverValidityState.read(in);
    }
}

