/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.SourceLevel;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.RegexpContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.BuildUtil;
import com.atlassian.clover.idea.build.InclusionDetector;
import com.atlassian.clover.idea.build.ProjectInclusionDetector;
import com.atlassian.clover.idea.build.VirtualFileInstrumentationSource;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.coverage.EventListenerInstallator;
import com.atlassian.clover.idea.util.CharsetUtil;
import com.atlassian.clover.idea.util.MiscUtils;
import com.atlassian.clover.idea.util.ProjectUtil;
import com.atlassian.clover.idea.util.tmp.TmpPathResolver;
import com.atlassian.clover.idea.util.ui.ExceptionDialog;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.atlassian.clover.instr.InstrumentationSessionImpl;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.RegistryFormatException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.JavaSourceTransformingCompiler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CloverCompiler
implements JavaSourceTransformingCompiler {
    private final Logger LOG = Logger.getInstance(CloverCompiler.class.getName());
    private final Project project;
    private Instrumenter instr;
    private final CloverCompilerStatus status = new CloverCompilerStatus();
    private final CompilationStatusListener internalBuildListener;
    private final CompilationStatusListener externalBuildListener;
    private static final Map<LanguageLevel, SourceLevel> LANGUAGE_LEVEL_TO_SOURCE_LEVEL = Collections.unmodifiableMap(new HashMap<LanguageLevel, SourceLevel>(){
        {
            this.put(LanguageLevel.JDK_1_9, SourceLevel.JAVA_9);
            this.put(LanguageLevel.JDK_1_8, SourceLevel.JAVA_8);
            this.put(LanguageLevel.JDK_1_7, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_6, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_5, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_4, SourceLevel.JAVA_7);
            this.put(LanguageLevel.JDK_1_3, SourceLevel.JAVA_7);
        }
    });

    public CloverCompiler(Project proj) {
        this.project = proj;
        this.internalBuildListener = new InternalCompilationStatusListener();
        this.registerInternalBuildListener(this.internalBuildListener);
        this.externalBuildListener = new ExternalCompilationStatusListener();
        this.registerExternalBuildListener(this.externalBuildListener);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        compilerManager.addBeforeTask((CompileTask)new CoverageDataCleanerTask(this.project));
        compilerManager.addBeforeTask((CompileTask)new ValidateInitStringTask());
        compilerManager.addBeforeTask((CompileTask)new ExcludeCloverWorkDirFromProjectTask());
    }

    @NotNull
    public String getDescription() {
        return "Clover Compiler";
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        if (!this.isCloverInstrumentationEnabled()) {
            return true;
        }
        this.initCompiler();
        IdeaCloverConfig config = ProjectPlugin.getPlugin(this.project).getConfig();
        return this.verifyInstrumenter(config);
    }

    public void cleanup() {
        this.unregisterInternalBuildListener(this.internalBuildListener);
    }

    public boolean isTransformable(VirtualFile file) {
        this.LOG.debug("isTransformable: " + file);
        if (!ProjectPlugin.getPlugin(this.project).getConfig().isBuildWithClover()) {
            return false;
        }
        InclusionDetector inclusion = ProjectInclusionDetector.processFile(this.project, file);
        if (inclusion.isCloverDisabled()) {
            return false;
        }
        if (inclusion.isNotJava()) {
            this.LOG.debug("Ignoring non-java file: " + file);
            return false;
        }
        if (inclusion.isModuleExcluded()) {
            this.LOG.debug("File belongs to excluded module: " + file);
            return false;
        }
        if (inclusion.isPatternExcluded()) {
            this.LOG.debug("Ignoring excluded file: " + file);
            return false;
        }
        if (inclusion.isInNoninstrumentedTestSources()) {
            this.LOG.debug("Ignoring marked test case: " + file);
            return false;
        }
        return inclusion.isIncluded();
    }

    public boolean transform(final CompileContext context, final VirtualFile vf, final VirtualFile origVf) {
        Application app = ApplicationManager.getApplication();
        return (Boolean)app.runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                CloverCompiler.this.LOG.debug("transform: " + vf + ", " + origVf);
                ((TmpPathResolver)ServiceManager.getService((Project)CloverCompiler.this.project, TmpPathResolver.class)).registerMapping(origVf, vf.getPath());
                try {
                    IdeaCloverConfig config = ProjectPlugin.getPlugin(CloverCompiler.this.project).getConfig();
                    Instrumenter instrumenter = CloverCompiler.this.getInstrumenter(config);
                    Module module = ModuleUtil.findModuleForFile((VirtualFile)origVf, (Project)CloverCompiler.this.project);
                    JavaInstrumentationConfig instrConfig = instrumenter.getConfig();
                    if (module != null) {
                        SourceLevel sourceLevel = CloverCompiler.languageLevelToSourceLevel(LanguageLevelUtil.getEffectiveLanguageLevel((Module)module));
                        CloverCompiler.this.LOG.debug("Source level " + sourceLevel.asString());
                        instrConfig.setSourceLevel(sourceLevel);
                    } else {
                        CloverCompiler.this.LOG.info("Cannot determine module for " + origVf + ", using previous source level " + (Object)((Object)instrConfig.getSourceLevel()));
                    }
                    CloverCompiler.this.status.instrumenting(context, origVf);
                    String fileEncoding = CharsetUtil.getFileEncoding(origVf);
                    OutputStreamWriter writer = fileEncoding == null ? new FileWriter(VfsUtil.convertToFile(vf)) : new OutputStreamWriter((OutputStream)new FileOutputStream(VfsUtil.convertToFile(vf)), fileEncoding);
                    VirtualFileInstrumentationSource input = new VirtualFileInstrumentationSource(origVf);
                    instrumenter.instrument(input, writer, fileEncoding);
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    CloverCompiler.this.LOG.info("Exception caught during compile.", e);
                    context.addMessage(CompilerMessageCategory.ERROR, "CloverException: " + e.getMessage(), origVf != null ? origVf.getUrl() : null, -1, -1);
                    return Boolean.FALSE;
                }
            }
        });
    }

    private void notifyWarning(Project project, String message) {
        ToolWindowManager.getInstance((Project)project).notifyByBalloon("Cloverage", MessageType.WARNING, message);
    }

    private void registerExternalBuildListener(CompilationStatusListener compilationStatusListener) {
        EventListenerInstallator.install(this.project, CompilerTopics.COMPILATION_STATUS, compilationStatusListener);
    }

    private void registerInternalBuildListener(CompilationStatusListener compilationStatusListener) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        compilerManager.addCompilationStatusListener(compilationStatusListener);
    }

    private void unregisterInternalBuildListener(CompilationStatusListener compilationStatusListener) {
        CompilerManager.getInstance((Project)this.project).removeCompilationStatusListener(compilationStatusListener);
    }

    private boolean verifyInstrumenter(IdeaCloverConfig config) {
        String msg;
        block5: {
            try {
                return this.getInstrumenter(config) != null;
            }
            catch (RegistryFormatException ex) {
                msg = "Clover was unable to instrument your source because of an error. Deleting the existing coverage database and trying again.";
                this.LOG.warn("Clover was unable to instrument your source because of an error. Deleting the existing coverage database and trying again.", ex);
                this.notifyWarning(this.project, "Clover was unable to instrument your source because of an error. Deleting the existing coverage database and trying again.");
            }
            catch (CloverException ex) {
                if (0 == ExceptionDialog.showYesNoDialog(this.project, "Clover was unable to instrument your source because of the following error:", "Delete the existing coverage database and try again?", ex, "Clover Instrumentation")) break block5;
                return false;
            }
        }
        ProjectPlugin.getPlugin(this.project).getCoverageManager().delete();
        try {
            return this.getInstrumenter(config) != null;
        }
        catch (Exception ex) {
            msg = "Clover instrumenter failed to initialize (after deleting coverage database)";
            this.LOG.warn("Clover instrumenter failed to initialize (after deleting coverage database)", ex);
            ExceptionDialog.showOKDialog(this.project, "Clover instrumenter failed to initialize (after deleting coverage database)", "", ex, "Initializing Clover Compiler");
            return false;
        }
    }

    private LanguageLevel findFirstLanguageLevel() {
        Module[] modules = ModuleManager.getInstance((Project)this.project).getModules();
        return modules.length > 0 ? LanguageLevelUtil.getEffectiveLanguageLevel((Module)modules[0]) : this.highestLangSupportByClovAndIntellij();
    }

    private LanguageLevel highestLangSupportByClovAndIntellij() {
        int jdk19Index = LanguageLevel.JDK_1_9.ordinal();
        return LanguageLevel.values()[Math.min(LanguageLevel.values().length, jdk19Index)];
    }

    static SourceLevel languageLevelToSourceLevel(LanguageLevel languageLevel) {
        SourceLevel level = LANGUAGE_LEVEL_TO_SOURCE_LEVEL.get(languageLevel);
        return level == null ? SourceLevel.JAVA_9 : level;
    }

    private void initCompiler() {
        this.instr = null;
        this.status.reset();
    }

    private Instrumenter getInstrumenter(IdeaCloverConfig config) throws CloverException {
        if (this.instr == null) {
            Clover2Registry registry;
            JavaInstrumentationConfig instrConfig = BuildUtil.configureNewInstrumenter(config, this.project);
            LanguageLevel lvl = this.findFirstLanguageLevel();
            instrConfig.setSourceLevel(CloverCompiler.languageLevelToSourceLevel(lvl));
            instrConfig.setEncoding(CharsetUtil.getProjectDefaultEncoding());
            Instrumenter instrumenter = new Instrumenter(instrConfig);
            try {
                CloverDatabase currentDatabase = ProjectPlugin.getPlugin(this.project).getCoverageManager().getCoverage();
                registry = currentDatabase != null ? currentDatabase.getRegistry() : Clover2Registry.createOrLoad(new File(config.getInitString()), this.project.getName());
            }
            catch (IOException e) {
                throw new CloverException(e);
            }
            ContextStore contextRegistry = new ContextStore();
            List<Regexp> regexpCtxList = config.getRegexpContexts();
            for (Regexp regexp : regexpCtxList) {
                if (!regexp.isValid()) continue;
                RegexpContext regexpContext = regexp.toContextSetting();
                if (regexpContext instanceof MethodRegexpContext) {
                    contextRegistry.addMethodContext((MethodRegexpContext)regexpContext);
                    continue;
                }
                contextRegistry.addStatementContext((StatementRegexpContext)regexpContext);
            }
            registry.setContextStore(contextRegistry);
            instrumenter.startInstrumentation(registry);
            this.instr = instrumenter;
        }
        return this.instr;
    }

    private boolean isCloverInstrumentationEnabled() {
        IdeaCloverConfig config = ProjectPlugin.getPlugin(this.project).getConfig();
        return config.isEnabled() && config.isBuildWithClover();
    }

    class CloverCompilerStatus {
        private int count;

        CloverCompilerStatus() {
        }

        void instrumenting(CompileContext context, VirtualFile file) {
            CloverCompiler.this.LOG.info("Instrumenting " + file);
            ++this.count;
            Module currentModule = context.getModuleByFile(file);
            context.getProgressIndicator().setText2("Files: " + this.count + " - Module: " + currentModule.getName());
            context.getProgressIndicator().setText("Instrumenting " + file.getName());
        }

        void reset() {
            this.count = 0;
        }
    }

    public class ExcludeCloverWorkDirFromProjectTask
    implements CompileTask {
        public boolean execute(CompileContext context) {
            MiscUtils.invokeWriteActionAndWait(new Runnable(){

                @Override
                public void run() {
                    File wksp = ProjectUtil.getProjectWorkspace(CloverCompiler.this.project);
                    if (wksp.exists()) {
                        ProjectUtil.excludeFromProject(CloverCompiler.this.project, LocalFileSystem.getInstance().refreshAndFindFileByIoFile(wksp));
                    }
                }
            });
            return true;
        }
    }

    class ValidateInitStringTask
    implements CompileTask {
        ValidateInitStringTask() {
        }

        public boolean execute(CompileContext context) {
            if (!CloverCompiler.this.isCloverInstrumentationEnabled()) {
                return true;
            }
            IdeaCloverConfig config = ProjectPlugin.getPlugin(CloverCompiler.this.project).getConfig();
            String initStr = config.getInitString();
            if (initStr == null || initStr.length() == 0) {
                Messages.showErrorDialog((String)"Please specify a valid Clover initString property before continuing.", (String)"Require Initialisation String.");
                return false;
            }
            File initStringFile = new File(initStr);
            if (!initStringFile.getParentFile().exists() && !initStringFile.getParentFile().mkdirs()) {
                String message = "Could not create coverage directory " + initStringFile.getParentFile();
                CloverCompiler.this.LOG.error(message);
                Messages.showErrorDialog((String)message, (String)"Invalid Initialisation String.");
                return false;
            }
            return true;
        }
    }

    class CoverageDataCleanerTask
    implements CompileTask {
        private final Project project;

        public CoverageDataCleanerTask(Project project) {
            this.project = project;
        }

        public boolean execute(CompileContext context) {
            VirtualFile[] projectFiles;
            if (context.isMake() || !CloverCompiler.this.isCloverInstrumentationEnabled()) {
                return true;
            }
            VirtualFile[] files = context.getCompileScope().getFiles(null, false);
            if (files.length == (projectFiles = context.getProjectCompileScope().getFiles(null, false)).length) {
                context.addMessage(CompilerMessageCategory.INFORMATION, "Clover: deleting coverage data.", null, -1, -1);
                CloverCompiler.this.instr = null;
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProjectPlugin.getPlugin(CoverageDataCleanerTask.this.project).getCoverageManager().delete();
                    }
                }, ModalityState.defaultModalityState());
            } else {
                Logger.getInstance(CoverageDataCleanerTask.class.getName()).info(MessageFormat.format("Coverage database not deleted: narrowed built detected ({0} of {1} files in the build scope)", files.length, projectFiles.length));
            }
            return true;
        }
    }

    class ExternalCompilationStatusListener
    implements CompilationStatusListener {
        ExternalCompilationStatusListener() {
        }

        public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            Runnable updateRegistryTask = new Runnable(){

                @Override
                public void run() {
                    CloverCompiler.this.LOG.info("CLOVER: COMPILATION IN EXTERNAL BUILD PROCESS HAS FINISHED");
                    if (!CloverCompiler.this.isCloverInstrumentationEnabled()) {
                        return;
                    }
                    CloverCompiler.this.LOG.info("CLOVER: RELOADING DATABASE AND COVERAGE DATA");
                    CoverageManager coverageManager = ProjectPlugin.getPlugin(CloverCompiler.this.project).getCoverageManager();
                    coverageManager.lockRegistryForUpdate(null);
                    coverageManager.releaseUpdatedRegistry(null);
                }
            };
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().invokeAndWait(updateRegistryTask, ModalityState.defaultModalityState());
            } else {
                updateRegistryTask.run();
            }
        }

        public void fileGenerated(String outputRoot, String relativePath) {
            CloverCompiler.this.LOG.info("External build - file generated: outputRoot=<" + outputRoot + "> relativePath=<" + relativePath + ">");
        }
    }

    class InternalCompilationStatusListener
    implements CompilationStatusListener {
        InternalCompilationStatusListener() {
        }

        public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            this.closeInstrumentationSession();
        }

        public void fileGenerated(String outputRoot, String relativePath) {
            CloverCompiler.this.LOG.debug("Internal build - file generated: outputRoot=<" + outputRoot + "> relativePath=<" + relativePath + ">");
        }

        private void closeInstrumentationSession() {
            if (CloverCompiler.this.instr != null) {
                try {
                    if (!CloverCompiler.this.isCloverInstrumentationEnabled()) {
                        return;
                    }
                    CoverageManager coverageManager = ProjectPlugin.getPlugin(CloverCompiler.this.project).getCoverageManager();
                    Clover2Registry registry = ((InstrumentationSessionImpl)CloverCompiler.this.instr.getSession()).getRegistry();
                    coverageManager.lockRegistryForUpdate(registry);
                    try {
                        CloverCompiler.this.instr.endInstrumentation(true);
                        CloverCompiler.this.instr = null;
                        CloverCompiler.this.LOG.info("completed Instrumentation.");
                    }
                    finally {
                        coverageManager.releaseUpdatedRegistry(registry);
                    }
                }
                catch (CloverException e) {
                    CloverCompiler.this.LOG.error(e);
                }
            }
        }
    }
}

