/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.autoupdater;

import com.atlassian.clover.idea.autoupdater.AutoUpdateComponent;
import com.atlassian.clover.idea.autoupdater.LatestVersionInfo;
import com.atlassian.clover.idea.autoupdater.NewVersionDialog;
import com.atlassian.clover.idea.autoupdater.StatusBarCloverIconWidget;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.idea.util.ui.ExceptionDialog;
import com.atlassian.clover.versions.LibraryVersion;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public class NewVersionNotifier
implements ProjectComponent {
    private final Project project;
    private final AutoUpdateComponent autoUpdateComponent;
    private StatusBarWidget notificationIconWidget;

    public NewVersionNotifier(Project project, AutoUpdateComponent autoUpdate) {
        this.project = project;
        this.autoUpdateComponent = autoUpdate;
    }

    public void update() {
        if (this.autoUpdateComponent.showNewVersionAvailable()) {
            this.addNotification();
        } else {
            this.removeNotification();
        }
    }

    public void checkNow() {
        LatestVersionInfo latestVersionInfo;
        try {
            latestVersionInfo = AutoUpdateComponent.checkLatestVersion();
        }
        catch (Exception e) {
            ExceptionDialog.showOKDialog(null, CloverIdeaPluginMessages.getString("autoupdate.errordownloadingdescriptor"), "", e, CloverIdeaPluginMessages.getString("autoupdate.errordownloadingdescriptor"));
            return;
        }
        if (new LibraryVersion("4.5.2").compareTo(new LibraryVersion(latestVersionInfo.getNumber())) >= 0) {
            Messages.showMessageDialog((Project)this.project, (String)CloverIdeaPluginMessages.getFormattedString("autoupdate.alreadylatest", "4.5.2"), (String)CloverIdeaPluginMessages.getString("autoupdate.updatingplugin"), (Icon)CloverIcons.CLOVER_BIG);
        } else {
            this.popNotificationDialog(latestVersionInfo);
        }
    }

    private void popNotificationDialog() {
        LatestVersionInfo latestVersionInfo = this.autoUpdateComponent.getLastVersion();
        if (latestVersionInfo != null) {
            this.autoUpdateComponent.resetLastVersion();
            this.popNotificationDialog(latestVersionInfo);
        }
    }

    public void popNotificationDialog(LatestVersionInfo latestVersionInfo) {
        NewVersionDialog dialog = new NewVersionDialog(latestVersionInfo);
        dialog.show();
        switch (dialog.getExitCode()) {
            case 0: {
                this.autoUpdateComponent.performUpdate(latestVersionInfo.getDownloadUrl());
                break;
            }
            case 2: {
                this.autoUpdateComponent.addIgnoredVersion(latestVersionInfo.getNumber());
            }
        }
    }

    private void addNotification() {
        WindowManager windowManager = WindowManager.getInstance();
        StatusBar statusBar = windowManager.getStatusBar(this.project);
        if (statusBar != null && this.notificationIconWidget == null) {
            this.notificationIconWidget = new StatusBarCloverIconWidget(new Consumer<MouseEvent>(){

                public void consume(MouseEvent mouseEvent) {
                    NewVersionNotifier.this.popNotificationDialog();
                }
            });
            statusBar.addWidget(this.notificationIconWidget);
            JFrame projectFrame = windowManager.getFrame(this.project);
            if (projectFrame != null) {
                projectFrame.validate();
            }
        }
    }

    private void removeNotification() {
        WindowManager windowManager = WindowManager.getInstance();
        StatusBar statusBar = windowManager.getStatusBar(this.project);
        if (statusBar != null && this.notificationIconWidget != null) {
            statusBar.removeWidget(this.notificationIconWidget.ID());
            this.notificationIconWidget = null;
            windowManager.getFrame(this.project).validate();
        }
    }

    public void projectOpened() {
        this.update();
    }

    public void projectClosed() {
        this.removeNotification();
    }

    @NotNull
    public String getComponentName() {
        return "Clover New Version Notifier";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static NewVersionNotifier getInstance(Project project) {
        return project != null ? (NewVersionNotifier)project.getComponent(NewVersionNotifier.class) : null;
    }
}

