/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.autoupdater;

import java.util.List;
import org.openclover.util.Lists;

public class AutoUpdateConfiguration {
    private boolean autoUpdate = true;
    private List<String> ignoredVersions = Lists.newArrayList();

    public AutoUpdateConfiguration(AutoUpdateConfiguration configuration) {
        this.autoUpdate = configuration.autoUpdate;
        this.ignoredVersions = Lists.newArrayList(configuration.ignoredVersions);
    }

    public AutoUpdateConfiguration() {
    }

    public AutoUpdateConfiguration(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public List<String> getIgnoredVersions() {
        return this.ignoredVersions;
    }

    public void setIgnoredVersions(List<String> list) {
        this.ignoredVersions = Lists.newArrayList(list);
    }

    public void addIgnoredVersion(String version) {
        this.ignoredVersions.add(version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoUpdateConfiguration)) {
            return false;
        }
        AutoUpdateConfiguration that = (AutoUpdateConfiguration)o;
        if (this.autoUpdate != that.autoUpdate) {
            return false;
        }
        return this.ignoredVersions.equals(that.ignoredVersions);
    }

    public int hashCode() {
        int result = this.autoUpdate ? 1 : 0;
        result = 31 * result + this.ignoredVersions.hashCode();
        return result;
    }
}

