/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.actions.excludes;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.actions.excludes.ExclusionUtil;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleInclusionAction
extends ToggleAction {
    abstract String getExistingPattern(IdeaCloverConfig var1);

    abstract void setPattern(IdeaCloverConfig var1, String var2);

    @Nullable
    static String getPattern(PsiElement element) {
        String recursivePattern = ExclusionUtil.getRecursivePattern(element);
        return recursivePattern != null ? recursivePattern : ExclusionUtil.getPattern(element);
    }

    static IdeaCloverConfig getConfig(AnActionEvent e) {
        IProjectPlugin plugin = ProjectPlugin.getPlugin(e);
        return plugin != null ? plugin.getConfig() : null;
    }

    public boolean isSelected(AnActionEvent e) {
        String pattern = AbstractToggleInclusionAction.getPattern((PsiElement)e.getData(DataKeys.PSI_ELEMENT));
        IdeaCloverConfig config = AbstractToggleInclusionAction.getConfig(e);
        return pattern != null && config != null && ExclusionUtil.isExplicitlyIncluded(this.getExistingPattern(config), pattern);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        String pattern = AbstractToggleInclusionAction.getPattern((PsiElement)e.getData(DataKeys.PSI_ELEMENT));
        IdeaCloverConfig config = AbstractToggleInclusionAction.getConfig(e);
        if (config == null) {
            return;
        }
        String existingPatterns = this.getExistingPattern(config);
        if (!ExclusionUtil.isExplicitlyIncluded(existingPatterns, pattern)) {
            if (existingPatterns == null || existingPatterns.trim().length() == 0) {
                this.setPattern(config, pattern);
            } else {
                this.setPattern(config, existingPatterns + ", " + pattern);
            }
        } else {
            String newPattern = ExclusionUtil.removePattern(existingPatterns, pattern);
            if (!newPattern.equals(pattern)) {
                this.setPattern(config, newPattern);
            }
        }
    }
}

