/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.idea.SelectInCloverView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Maps;

public class SelectInCloverTarget
implements SelectInTarget {
    private final Map<Priority, SelectInCloverView> views = Maps.newTreeMap();

    public static SelectInCloverTarget getInstance(@NotNull Project project) {
        return (SelectInCloverTarget)project.getPicoContainer().getComponentInstanceOfType(SelectInCloverTarget.class);
    }

    public void addView(SelectInCloverView view, int priority) {
        this.views.put(new Priority(priority), view);
    }

    public void removeView(SelectInCloverView view) {
        this.views.values().remove(view);
    }

    public boolean canSelect(SelectInContext context) {
        for (SelectInCloverView view : this.views.values()) {
            if (!view.canSelect(context)) continue;
            return true;
        }
        return false;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        for (SelectInCloverView view : this.views.values()) {
            if (!view.selectIn(context)) continue;
            return;
        }
    }

    public String getToolWindowId() {
        return null;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return Float.MAX_VALUE;
    }

    public String toString() {
        return "Clover";
    }

    private static class Priority
    implements Comparable<Priority> {
        private final int priority;
        private static int tieBreakerCounter;
        private final int tieBreaker = ++tieBreakerCounter;

        public Priority(int priority) {
            this.priority = priority;
        }

        @Override
        public int compareTo(Priority o) {
            return this.priority != o.priority ? this.priority - o.priority : this.tieBreaker - o.tieBreaker;
        }
    }
}

