/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.idea.util.MiscUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com_atlassian_clover.CoverageRecorder;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

public class LibrarySupport {
    public static final String LIBRARY_NAME = "Clover IDEA Plugin";
    private static final Logger LOG = Logger.getInstance((String)LibrarySupport.class.getName());

    private LibrarySupport() {
    }

    public static Library lookupCloverLibrary() {
        return LibrarySupport.getAppLibraryTable().getLibraryByName(LIBRARY_NAME);
    }

    public static Library createCloverLibrary() {
        LibraryTable.ModifiableModel tableModel = LibrarySupport.getAppLibraryTable().getModifiableModel();
        Library cloverLibrary = tableModel.createLibrary(LIBRARY_NAME);
        tableModel.commit();
        return cloverLibrary;
    }

    public static Library getValidatedCloverLibrary() {
        VirtualFile classesBase;
        Library library = LibrarySupport.lookupCloverLibrary();
        if (library == null) {
            library = LibrarySupport.createCloverLibrary();
        }
        if ((classesBase = LibrarySupport.getCloverClassBase()) == null) {
            LOG.info("Unable to update 'Clover IDEA Plugin' classpath.");
            return library;
        }
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        String[] currentFiles = libraryModel.getUrls(OrderRootType.CLASSES);
        boolean found = false;
        boolean dirty = false;
        for (String currentFile : currentFiles) {
            if (currentFile.equals(classesBase.getUrl())) {
                found = true;
                continue;
            }
            libraryModel.removeRoot(currentFile, OrderRootType.CLASSES);
            dirty = true;
        }
        if (!found) {
            libraryModel.addRoot(classesBase, OrderRootType.CLASSES);
            dirty = true;
        }
        if (dirty) {
            libraryModel.commit();
        }
        return library;
    }

    @Nullable
    public static VirtualFile getCloverClassBase() {
        try {
            final URL targetUrl = LibrarySupport.getSourceCloverJarUrl();
            VirtualFile targetVf = VfsUtil.findFileByURL((URL)targetUrl);
            if (targetVf == null) {
                final VirtualFile[] vf = new VirtualFile[1];
                MiscUtils.invokeWriteActionAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LOG.debug("Clover: VfsUtil.findFileByURL(\"" + targetUrl + "\") returned null. Refreshing VFS.");
                        String targetUrlFix = targetUrl.toString().replace("file:/", "file:///");
                        vf[0] = VirtualFileManager.getInstance().refreshAndFindFileByUrl(targetUrlFix);
                    }
                });
                targetVf = vf[0];
                if (targetVf == null) {
                    LOG.info("Failed to locate Clover JAR '" + targetUrl + "'.");
                }
            }
            return targetVf;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static URL getSourceCloverJarUrl() {
        try {
            Class<CoverageRecorder> recorderClass = CoverageRecorder.class;
            String path = "/" + recorderClass.getName().replace('.', '/') + ".class";
            URL recorderClassUrl = recorderClass.getResource(path);
            return new URL(recorderClassUrl.toString().replace(path, "/"));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean addLibraryTo(Library lib, Module module) {
        LOG.debug("addLibraryTo(" + lib.getName() + ", " + module.getName() + ");");
        OrderEntry[] existingEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        if (existingEntries.length > 0 && existingEntries[0] instanceof LibraryOrderEntry && lib.equals(((LibraryOrderEntry)existingEntries[0]).getLibrary())) {
            return false;
        }
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        LibraryOrderEntry existingEntry = rootModel.findLibraryOrderEntry(lib);
        if (existingEntry != null) {
            OrderEntry[] orderEntries = rootModel.getOrderEntries();
            LibrarySupport.reorderEntries(orderEntries, (OrderEntry)existingEntry);
            rootModel.rearrangeOrderEntries(orderEntries);
        } else {
            LOG.debug("Library not found in module. Adding. +++++++++++++");
            LibraryOrderEntry orderEntry = rootModel.addLibraryEntry(lib);
            OrderEntry[] orderEntries = rootModel.getOrderEntries();
            if (LibrarySupport.reorderEntries(orderEntries, (OrderEntry)orderEntry)) {
                rootModel.rearrangeOrderEntries(orderEntries);
            }
            LibrarySupport.logDebugPrintCompilationClasses(module);
        }
        rootModel.commit();
        return true;
    }

    private static VirtualFile[] getCompilationClasses(Module module) {
        return OrderEnumerator.orderEntries((Module)module).getAllSourceRoots();
    }

    private static void logDebugPrintCompilationClasses(Module module) {
        LOG.debug("ModuleRootModel compilation classes: ");
        VirtualFile[] vf = LibrarySupport.getCompilationClasses(module);
        for (int i = 0; i < vf.length; ++i) {
            VirtualFile f = vf[i];
            LOG.debug("" + i + ": " + f.getPresentableUrl());
        }
    }

    static boolean reorderEntries(OrderEntry[] entries, OrderEntry makeFirst) {
        int i;
        for (i = entries.length - 1; i >= 0 && entries[i] != makeFirst; --i) {
        }
        if (i < 1) {
            return false;
        }
        while (i > 0) {
            entries[i] = entries[i - 1];
            --i;
        }
        entries[0] = makeFirst;
        return true;
    }

    public static boolean removeCloverLibraryFrom(Module module) {
        return LibrarySupport.removeLibraryFrom(module, LIBRARY_NAME);
    }

    public static boolean removeLibraryFrom(Module module, String libraryName) {
        if (LibrarySupport.containsLibrary(module, libraryName)) {
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry entry : rootModel.getOrderEntries()) {
                if (!libraryName.equals(entry.getPresentableName())) continue;
                rootModel.removeOrderEntry(entry);
            }
            rootModel.commit();
            return true;
        }
        return false;
    }

    private static boolean containsLibrary(Module module, String libraryName) {
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!libraryName.equals(entry.getPresentableName())) continue;
            return true;
        }
        return false;
    }

    private static LibraryTable getAppLibraryTable() {
        return LibraryTablesRegistrar.getInstance().getLibraryTable();
    }
}

