/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AntFileSetUtils;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class FilesetFilter
implements HasMetricsFilter {
    private final Set<File> files = Sets.newHashSet();
    private final Map<String, Set<String>> fileNamesToPaths = Maps.newHashMap();

    public FilesetFilter(Project p, List<FileSet> fileSets) {
        for (FileSet fileset : fileSets) {
            String[] includedFiles;
            File baseDir = fileset.getDir(p);
            Logger.getInstance().verbose("Scanning files to filter in " + baseDir + " ; exists = " + baseDir.exists() + " ; is directory = " + baseDir.isDirectory());
            AntFileSetUtils.checkForNonTrimmedPatterns(fileset, p);
            String[] stringArray = includedFiles = fileset.getDirectoryScanner(p).getIncludedFiles();
            int n = includedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String includedFile = stringArray[n2];
                File file = new File(baseDir, includedFile);
                Logger.getInstance().verbose("Adding to fileset filter: " + file.getPath());
                Set<String> paths = this.fileNamesToPaths.get(file.getName());
                if (paths == null) {
                    paths = Sets.newHashSet();
                    this.fileNamesToPaths.put(file.getName(), paths);
                }
                paths.add(file.getAbsolutePath());
                this.files.add(file);
                ++n2;
            }
        }
    }

    @Override
    public boolean accept(HasMetrics hm) {
        if (hm instanceof FullFileInfo) {
            FullFileInfo fileInfo = (FullFileInfo)hm;
            if (this.exactMatch(fileInfo) || this.fuzzyMatch(fileInfo)) {
                Logger.getInstance().verbose("Including file " + fileInfo.getPhysicalFile().getPath());
                return true;
            }
            Logger.getInstance().verbose("Excluding file " + fileInfo.getPhysicalFile().getPath());
            return false;
        }
        return true;
    }

    private boolean exactMatch(FullFileInfo fileInfo) {
        boolean matches = this.files.contains(fileInfo.getPhysicalFile());
        Logger.getInstance().debug("Exact filter matching on " + fileInfo.getPhysicalFile().getPath() + ": " + matches);
        return matches;
    }

    private boolean fuzzyMatch(FullFileInfo fileInfo) {
        Logger.getInstance().debug("Fuzzy: trying to matching " + fileInfo.getPhysicalFile().getPath() + " with fuzzy matching");
        Set<String> paths = this.fileNamesToPaths.get(fileInfo.getName());
        if (paths != null) {
            Logger.getInstance().debug("Fuzzy: paths for " + fileInfo.getName() + ": " + paths);
            String packagePath = fileInfo.getPackagePath();
            for (String path : paths) {
                String normalizedPath = FileUtils.getNormalizedPath(path);
                if (normalizedPath.endsWith(packagePath)) {
                    Logger.getInstance().debug("Fuzzy: normalized path " + normalizedPath + " ends with packagePath " + packagePath);
                    return true;
                }
                Logger.getInstance().debug("Fuzzy: normalized path " + normalizedPath + " does not end with packagePath " + packagePath);
            }
            Logger.getInstance().debug("Fuzzy: no matching paths");
        } else {
            Logger.getInstance().debug("Fuzzy: no paths to match on for " + fileInfo.getName());
        }
        return false;
    }
}

