/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.ant.tasks.CloverReportTask;
import com.atlassian.clover.ant.tasks.HistoryPointTask;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.pdf.PDFReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class CloverPdfReportTask
extends CloverReportTask {
    private String title = "";
    private File outfile;
    private final CloverReportTask.CurrentEx current = new CloverReportTask.CurrentEx();
    private CloverReportTask.HistoricalEx historical;

    public void setHistorydir(File historydir) {
        this.historical = new CloverReportTask.HistoricalEx();
        this.historical.setHistoryDir(historydir);
    }

    public void addColumns(Columns columns) {
        this.current.setColumns(columns);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    @Override
    public void cloverExecute() {
        if (this.outfile == null) {
            throw new BuildException("'outfile' attribute is required.");
        }
        this.current.setFormat(this.getFormat());
        this.current.setTitle(this.title);
        this.current.setOutFile(this.outfile);
        this.current.setSummary(true);
        this.current.setCoverageCacheSize(this.coverageCacheSize);
        this.addCurrent(this.current);
        if (this.historical != null) {
            if (!this.historical.getHistoryDir().exists() && !this.historical.getHistoryDir().mkdirs()) {
                throw new BuildException("Unable to create history dir '" + this.historical.getHistoryDir() + "'");
            }
            HistoryPointTask hptask = new HistoryPointTask();
            hptask.setProject(this.getProject());
            hptask.init();
            hptask.setHistoryDir(this.historical.getHistoryDir());
            hptask.setInitString(this.resolveInitString());
            hptask.setAlwaysReport(true);
            hptask.setTaskName(this.getTaskName());
            hptask.cloverExecute();
            this.historical.setFormat(this.getFormat());
            this.historical.setTitle(this.title);
            this.historical.setOutFile(this.outfile);
            this.addHistorical(this.historical);
        }
        super.cloverExecute();
    }

    protected Format getFormat() {
        return Format.DEFAULT_PDF;
    }

    @Override
    protected void generateReports(CloverReportConfig firstCurrentConfig, CloverReportConfig[] configs, Map<String, CloverReportConfig> linkedReports) throws CloverException {
        CloverReportConfig config = configs[0];
        TreeMap myLinkedReports = Maps.newTreeMap();
        myLinkedReports.putAll(linkedReports);
        myLinkedReports.remove(config.getUniqueTitle());
        ArrayList secondaryReports = Lists.newArrayList(myLinkedReports.values());
        if (!config.validate()) {
            throw new CloverException(config.getValidationFailureReason());
        }
        new PDFReporter(config, secondaryReports.toArray(new CloverReportConfig[0])).execute();
    }
}

