/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CodeType;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.ant.tasks.CloverReportTask;
import com.atlassian.clover.ant.tasks.FilesetFileVisitor;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.cfg.Percentage;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.BlockMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.util.HistoricalSupport;
import com.atlassian.clover.reporters.util.MetricsDiffSummary;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.StringUtils;
import org.openclover.util.Lists;

public class CloverPassTask
extends AbstractCloverTask {
    private File historydir;
    private File[] historyFiles;
    private double threshold;
    private HistoricalSupport.HasMetricsWrapper model;
    private Map models;
    private Percentage targetPC = null;
    private Percentage methodTarget;
    private Percentage statementTarget;
    private Percentage conditionalTarget;
    private boolean haltOnFailure = false;
    private String failureProperty;
    final Current currentConfig = new Current();
    private List testResults = Lists.newArrayList();
    private List testSources = Lists.newArrayList();
    private CodeType codeType = CodeType.APPLICATION;
    private List<PackageRequirement> packageRequirements = Lists.newArrayList();

    public void setCodeType(String codeTypeAsString) {
        try {
            this.codeType = CodeType.valueOf(codeTypeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.codeType = null;
        }
    }

    @Override
    public void init() throws BuildException {
        super.init();
        this.currentConfig.setFormat(Format.DEFAULT_XML);
    }

    public void addPackage(PackageRequirement requirement) {
        this.packageRequirements.add(requirement);
    }

    public void setHistorydir(File historydir) {
        this.historydir = historydir;
    }

    public File getHistorydir() {
        return this.historydir;
    }

    public void setThreshold(Percentage threshold) {
        this.threshold = (double)threshold.getAsFloatFraction() * 100.0;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setTarget(Percentage percentValue) {
        this.targetPC = percentValue;
    }

    public Percentage getMethodTarget() {
        return this.methodTarget;
    }

    public void setMethodTarget(Percentage methodTarget) {
        this.methodTarget = methodTarget;
    }

    public Percentage getStatementTarget() {
        return this.statementTarget;
    }

    public void setStatementTarget(Percentage statementTarget) {
        this.statementTarget = statementTarget;
    }

    public Percentage getConditionalTarget() {
        return this.conditionalTarget;
    }

    public void setConditionalTarget(Percentage conditionalTarget) {
        this.conditionalTarget = conditionalTarget;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFilter(String filterSpec) {
        this.currentConfig.getFormat().setFilter(filterSpec);
    }

    public void setSpan(Interval span) {
        this.currentConfig.setSpan(span);
    }

    public void addTestResults(FileSet fileset) {
        this.testResults.add(fileset);
    }

    public void setIncludeFailedTestCoverage(boolean include) {
        this.currentConfig.setIncludeFailedTestCoverage(include);
    }

    public void addTestSources(FileSet fileset) {
        this.testSources.add(fileset);
    }

    public List getTestSources() {
        return this.testSources;
    }

    private void initFileSets() {
        FilesetFileVisitor.Util.collectFiles(this.getProject(), this.testResults, new FilesetFileVisitor(){

            @Override
            public void visit(File file) {
                CloverPassTask.this.currentConfig.addTestResultFile(file);
            }
        });
        FilesetFileVisitor.Util.collectFiles(this.getProject(), this.testSources, new FilesetFileVisitor(){

            @Override
            public void visit(File file) {
                CloverPassTask.this.currentConfig.addTestSourceFile(file);
            }
        });
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    @Override
    public void cloverExecute() {
        CloverDatabase db;
        boolean passed = true;
        StringBuffer targetFailures = new StringBuffer("");
        this.initFileSets();
        String initString = this.resolveInitString();
        this.currentConfig.setInitString(initString);
        if (this.targetPC == null && this.methodTarget == null && this.statementTarget == null && this.conditionalTarget == null && this.packageRequirements.size() == 0 && this.getHistorydir() == null) {
            throw new BuildException("You need to set either an overall target using one or more of the \"target\",\"methodTarget\",\"statementTarget\",\"conditionalTarget\" or \"historydir\" attribs, or specify atleast one nested <package> element.");
        }
        if (this.codeType == null) {
            throw new BuildException("You need to set a valid code type. Valid values are: \"" + CodeType.APPLICATION.name().toLowerCase(Locale.ENGLISH) + "\",\"" + CodeType.TEST.name().toLowerCase(Locale.ENGLISH) + "\",\"" + CodeType.ALL.name().toLowerCase() + "\"");
        }
        for (PackageRequirement requirement : this.packageRequirements) {
            if (requirement.target == null && requirement.methodTarget == null && requirement.statementTarget == null && requirement.conditionalTarget == null && this.getHistorydir() == null || requirement.name == null && requirement.regex == null) {
                throw new BuildException("The <package> element requires a \"name\" or \"regex\" attribute and one or more of the \"target\", \"methodTarget\",\"statementTarget\",\"conditionalTarget\" or \"historydir\" attributes.");
            }
            if (requirement.name == null || requirement.regex == null) continue;
            throw new BuildException("The <package> element requires either the \"name\" or \"regex\" attribute set, not both.");
        }
        try {
            db = this.currentConfig.getCoverageDatabase();
        }
        catch (CloverException e) {
            throw new BuildException("Unable to read Clover coverage database", (Throwable)e);
        }
        FullProjectInfo projectInfo = db.getModel(this.codeType);
        ProjectMetrics metrics = (ProjectMetrics)projectInfo.getMetrics();
        Logger.getInstance().debug("coverage = " + metrics.getPcCoveredElements());
        passed = this.checkCoverageFor(metrics.getPcCoveredElements(), this.targetPC, targetFailures, "Total", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredMethods(), this.methodTarget, targetFailures, "Method", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredStatements(), this.statementTarget, targetFailures, "Statement", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredBranches(), this.conditionalTarget, targetFailures, "Conditional", "target") && passed;
        try {
            passed = this.checkHistoryDirCoverage(metrics.getPcCoveredElements(), targetFailures, "Total", null) && passed;
        }
        catch (CloverException | IOException e) {
            throw new BuildException((Throwable)e);
        }
        for (final PackageRequirement requirement : this.packageRequirements) {
            ArrayList<PackageInfo> matchedPackages = Lists.newArrayList();
            if (requirement.name != null) {
                PackageInfo packageInfo = projectInfo.getNamedPackage(requirement.name);
                if (packageInfo == null) {
                    throw new BuildException("No coverage information for specified package: " + requirement.name);
                }
                matchedPackages.add(packageInfo);
            } else if (requirement.regex != null) {
                try {
                    matchedPackages.addAll(projectInfo.getPackages(new HasMetricsFilter(){

                        @Override
                        public boolean accept(HasMetrics node) {
                            return node.getName().matches(requirement.regex);
                        }
                    }));
                }
                catch (PatternSyntaxException e) {
                    throw new BuildException("Invalid package regular expression '" + requirement.regex + "': " + e.getMessage());
                }
            }
            for (PackageInfo packageInfo : matchedPackages) {
                String packageName = packageInfo.getName();
                PackageMetrics pm = (PackageMetrics)packageInfo.getMetrics();
                String errorPrefix = "Package " + packageName;
                passed = this.checkCoverageFor(pm.getPcCoveredElements(), requirement.target, targetFailures, String.valueOf(errorPrefix) + " total", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredMethods(), requirement.methodTarget, targetFailures, String.valueOf(errorPrefix) + " method", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredStatements(), requirement.statementTarget, targetFailures, String.valueOf(errorPrefix) + " statement", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredBranches(), requirement.conditionalTarget, targetFailures, String.valueOf(errorPrefix) + " conditional", "target") && passed;
                try {
                    passed = this.checkHistoryDirCoverage(pm.getPcCoveredElements(), targetFailures, String.valueOf(errorPrefix) + " total", packageName) && passed;
                }
                catch (CloverException | IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        if (!passed && targetFailures.lastIndexOf(StringUtils.LINE_SEP) == targetFailures.length() - StringUtils.LINE_SEP.length()) {
            targetFailures.delete(targetFailures.length() - StringUtils.LINE_SEP.length(), targetFailures.length());
        }
        if (!passed) {
            this.log("Coverage check FAILED");
            String failMessage = "The following coverage targets for " + this.getProject().getName() + " were not met: " + StringUtils.LINE_SEP + targetFailures;
            this.log(failMessage, 0);
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, targetFailures.toString());
            }
            if (this.haltOnFailure) {
                throw new BuildException("Build failed to meet Clover coverage targets: " + failMessage);
            }
        } else {
            this.log("Coverage check PASSED");
        }
    }

    private boolean checkCoverageFor(float coverage, Percentage targetCoverage, StringBuffer failures, String level, String target) {
        DecimalFormat pcFormat = new DecimalFormat("###.#%");
        if (targetCoverage != null) {
            if (BlockMetrics.isUndefined(coverage)) {
                Logger.getInstance().debug("Recorded coverage = " + coverage + " means undefined value, so cannot compare against target coverage = " + targetCoverage + ". Returning PASS (true).");
                return true;
            }
            pcFormat.setMinimumFractionDigits(targetCoverage.getScale());
            if (targetCoverage.compare(coverage) > 0) {
                failures.append(String.format("%s coverage of %s did not meet %s of %s", level, pcFormat.format(coverage), target, pcFormat.format(targetCoverage.getAsFloatFraction())));
                failures.append(StringUtils.LINE_SEP);
                return false;
            }
            Logger.getInstance().debug("recorded coverage = " + pcFormat.format(coverage) + "; target coverage = " + pcFormat.format(targetCoverage.getAsFloatFraction()));
        }
        return true;
    }

    private boolean checkHistoryDirCoverage(float coverage, StringBuffer failures, String level, String pkg) throws IOException, CloverException {
        if (this.getHistorydir() != null) {
            this.historyFiles = this.getHistoryFiles();
            this.model = this.getLastModel();
            if (this.model != null) {
                HasMetrics then = HistoricalSupport.getFullMetrics(this.model, pkg);
                if (then != null) {
                    Percentage targetCoverage = new Percentage("" + ((double)then.getMetrics().getPcCoveredElements() * 100.0 - this.threshold));
                    targetCoverage.setScale(2);
                    boolean passed = this.checkCoverageFor(coverage, targetCoverage, failures, level, "last history point target");
                    if (!passed) {
                        this.appendClassInfo(then, pkg, failures);
                    }
                    return passed;
                }
                Logger.getInstance().debug("Package " + pkg + " is new, the last history point target is met.");
            }
        }
        return true;
    }

    private void appendClassInfo(HasMetrics then, String pkg, StringBuffer failures) throws CloverException {
        EntityContainer now = pkg == null ? this.currentConfig.getCoverageDatabase().getModel(this.codeType) : this.currentConfig.getCoverageDatabase().getModel(this.codeType).getNamedPackage(pkg);
        List<MetricsDiffSummary> added = HistoricalSupport.getClassesMetricsDifference(then, now, new Percentage("0"), false);
        for (MetricsDiffSummary diff : added) {
            DecimalFormat diffFormat = new DecimalFormat("###.#");
            failures.append(String.format("  %s%% %s (Added)%s", diffFormat.format(diff.getPc2()), diff.getName(), StringUtils.LINE_SEP));
        }
        List<MetricsDiffSummary> diffs = HistoricalSupport.getClassesMetricsDifference(then, now, new Percentage("0"), true);
        for (MetricsDiffSummary diff : diffs) {
            if (!(diff.getPcDiff() < 0.0f)) continue;
            DecimalFormat diffFormat = new DecimalFormat("###.#");
            failures.append(String.format("  %s to %s%% %s%s", diffFormat.format(diff.getPcDiff()), diffFormat.format(diff.getPc2()), diff.getName(), StringUtils.LINE_SEP));
        }
    }

    private HistoricalSupport.HasMetricsWrapper getLastModel() throws IOException, CloverException {
        if (this.models == null) {
            this.models = HistoricalSupport.getAllProjectMetrics(this.historyFiles);
            if (!this.models.isEmpty()) {
                Object[] modelArray = this.models.keySet().toArray();
                long currentVersion = this.currentConfig.getCoverageDatabase().getModel(this.codeType).getVersion();
                int i = modelArray.length - 1;
                while (i >= 0) {
                    if ((Long)modelArray[i] < currentVersion) {
                        Logger.getInstance().debug("Comparing current version " + new Date(currentVersion) + " with history version " + new Date((Long)modelArray[i]));
                        return (HistoricalSupport.HasMetricsWrapper)this.models.get(modelArray[i]);
                    }
                    --i;
                }
                Logger.getInstance().debug("History points exist but are newer than the database being checked.");
            } else {
                Logger.getInstance().debug("No history points exist.");
            }
        }
        return this.model;
    }

    private File[] getHistoryFiles() {
        if (this.historyFiles == null) {
            this.historyFiles = CloverReportTask.HistoricalEx.processHistoryIncludes(this.getProject(), null, this.getHistorydir());
        }
        return this.historyFiles;
    }

    public static class PackageRequirement {
        private String name;
        private String regex;
        private Percentage target;
        private Percentage methodTarget;
        private Percentage statementTarget;
        private Percentage conditionalTarget;

        public void setName(String name) {
            this.name = name;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public void setTarget(Percentage target) {
            this.target = target;
        }

        public Percentage getMethodTarget() {
            return this.methodTarget;
        }

        public void setMethodTarget(Percentage methodTarget) {
            this.methodTarget = methodTarget;
        }

        public Percentage getStatementTarget() {
            return this.statementTarget;
        }

        public void setStatementTarget(Percentage statementTarget) {
            this.statementTarget = statementTarget;
        }

        public Percentage getConditionalTarget() {
            return this.conditionalTarget;
        }

        public void setConditionalTarget(Percentage conditionalTarget) {
            this.conditionalTarget = conditionalTarget;
        }
    }
}

