/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing.provider;

import clover.net.sf.jtreemap.swing.ColorProvider;
import clover.net.sf.jtreemap.swing.JTreeMap;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.Value;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class RedGreenColorProvider
extends ColorProvider {
    private static final int COLOUR_MAX_VALUE = 255;
    private static final long serialVersionUID = 5030306338780462810L;
    private final JTreeMap jTreeMap;
    private JPanel legend;
    private Value maxAbsValue;
    private Value minVal;
    private final int[] tabColor = new int[]{0, 60, 102, 153, 204, 255};
    private static final int[] TAB_LIMIT_VALUE = new int[]{25, 76, 123, 179, 230, 255};

    public RedGreenColorProvider(JTreeMap jTreeMap) {
        this.jTreeMap = jTreeMap;
    }

    public Color getColor(Value value) {
        double dValeur;
        int colorIndex;
        if (this.maxAbsValue == null) {
            this.setMaxValue(this.jTreeMap.getRoot());
        }
        if ((colorIndex = (int)(255.0 * Math.abs(dValeur = value != null ? value.getValue() : 0.0) / this.maxAbsValue.getValue())) > 255) {
            colorIndex = 255;
        }
        for (int i = 0; i < TAB_LIMIT_VALUE.length; ++i) {
            if (colorIndex > TAB_LIMIT_VALUE[i]) continue;
            colorIndex = this.tabColor[i];
            break;
        }
        if (dValeur >= 0.0) {
            return new Color(0, colorIndex, 0);
        }
        return new Color(colorIndex, 0, 0);
    }

    public JPanel getLegendPanel() {
        if (this.legend == null) {
            if (this.maxAbsValue == null) {
                this.setMaxValue(this.jTreeMap.getRoot());
            }
            this.legend = new Legend();
        }
        return this.legend;
    }

    private void setMaxValue(TreeMapNode root) {
        if (root.isLeaf()) {
            Value value = root.getValue();
            if (value != null && (this.maxAbsValue == null || Math.abs(value.getValue()) > this.maxAbsValue.getValue())) {
                try {
                    Class<?> c = value.getClass();
                    if (this.maxAbsValue == null || this.minVal == null) {
                        this.maxAbsValue = (Value)c.newInstance();
                        this.minVal = (Value)c.newInstance();
                    }
                    this.minVal.setValue(-Math.abs(value.getValue()));
                    this.maxAbsValue.setValue(Math.abs(value.getValue()));
                }
                catch (IllegalAccessException iae) {
                }
                catch (InstantiationException ie) {}
            }
        } else {
            for (TreeMapNode node : root.getChildren()) {
                this.setMaxValue(node);
            }
        }
    }

    private class Legend
    extends JPanel {
        private static final int Y_INSET = 7;
        private static final int X_INSET = 15;
        private static final long serialVersionUID = -536198802533900214L;
        private static final int HEIGHT = 20;
        private static final int WIDTH = 10;
        private static final int X = 20;
        private static final int Y = 25;

        public Legend() {
            this.setPreferredSize(new Dimension(40 + RedGreenColorProvider.this.tabColor.length * 10, 70));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (RedGreenColorProvider.this.minVal == null || RedGreenColorProvider.this.maxAbsValue == null) {
                return;
            }
            int xCursor = 0;
            for (int i = RedGreenColorProvider.this.tabColor.length - 1; i > 0; --i) {
                g.setColor(new Color(RedGreenColorProvider.this.tabColor[i], 0, 0));
                g.fillRect(20 + xCursor * 10, 25, 10, 20);
                ++xCursor;
            }
            g.setColor(Color.black);
            g.drawString(RedGreenColorProvider.this.minVal.getLabel(), 5, 18);
            g.drawString("0", 20 + xCursor * 10, 18);
            for (int element : RedGreenColorProvider.this.tabColor) {
                g.setColor(new Color(0, element, 0));
                g.fillRect(20 + xCursor * 10, 25, 10, 20);
                ++xCursor;
            }
            g.setColor(Color.black);
            g.drawString(RedGreenColorProvider.this.maxAbsValue.getLabel(), 20 + (xCursor - 1) * 10, 18);
        }
    }
}

