/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing.example;

import clover.net.sf.jtreemap.swing.ColorProvider;
import clover.net.sf.jtreemap.swing.JTreeMap;
import clover.net.sf.jtreemap.swing.SplitBySortedWeight;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.example.BuilderTM3;
import clover.net.sf.jtreemap.swing.example.BuilderXML;
import clover.net.sf.jtreemap.swing.example.DemoUtil;
import clover.net.sf.jtreemap.swing.provider.HSBTreeMapColorProvider;
import clover.net.sf.jtreemap.swing.provider.RandomColorProvider;
import clover.net.sf.jtreemap.swing.provider.RedGreenColorProvider;
import clover.net.sf.jtreemap.swing.provider.ZoomPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class JTreeMapAppletExample
extends JApplet {
    private static final double CONSTRAINT_WEIGHTX = 0.5;
    private static final int SCROLLPANE_WIDTH = 140;
    private static final String XML = "xml";
    private static final String TM3 = "tm3";
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final long serialVersionUID = -8376357344981512167L;
    private JTreeMap jTreeMap;
    private JPanel jContentPane = null;
    private JComboBox cmbValue;
    private JComboBox cmbWeight;
    private JPanel panelTM3;
    private BuilderTM3 builderTM3;
    private boolean showTM3CTonf;
    private boolean showTree;
    private boolean showWeight;
    private String weightPrefix;
    private String valuePrefix;
    private JTree treeView;
    private DefaultTreeModel treeModel;

    private void initGUI() {
        this.setContentPane(this.getJContentPane());
        this.showTM3CTonf = "true".equalsIgnoreCase(this.getParameter("showTM3Conf"));
        this.showTree = "true".equalsIgnoreCase(this.getParameter("viewTree"));
        this.showWeight = "true".equalsIgnoreCase(this.getParameter("showWeight"));
        this.weightPrefix = this.getParameter("weightPrefix");
        this.valuePrefix = this.getParameter("valuePrefix");
        if (this.showTM3CTonf) {
            this.addPanelEast(this.getJContentPane());
        }
        String dataFile = this.getParameter("dataFile");
        String dataFileType = this.getParameter("dataFileType");
        TreeMapNode root = null;
        if (TM3.equalsIgnoreCase(dataFileType)) {
            try {
                this.builderTM3 = new BuilderTM3(this.createReader(dataFile));
                root = this.builderTM3.getRoot();
                if (this.showTM3CTonf) {
                    this.setTM3Fields();
                    this.panelTM3.setVisible(true);
                }
            }
            catch (IOException e) {
                root = this.handleException(e);
            }
        } else if (XML.equalsIgnoreCase(dataFileType)) {
            try {
                URL url = new URL(this.getCodeBase() + dataFile);
                URLConnection connection = url.openConnection();
                BuilderXML bXml = new BuilderXML(connection.getInputStream());
                root = bXml.getRoot();
            }
            catch (ParseException e) {
                root = this.handleException(e);
            }
            catch (MalformedURLException e) {
                root = this.handleException(e);
            }
            catch (IOException e) {
                root = this.handleException(e);
            }
        } else {
            root = DemoUtil.buildDemoRoot();
        }
        this.jTreeMap = new JTreeMap(root, new SplitBySortedWeight(), this.treeView, this.weightPrefix, this.valuePrefix, this.showWeight);
        this.jTreeMap.setFont(new Font(null, 1, 12));
        String colourProvider = this.getParameter("colorProvider");
        ColorProvider colourProviderInstance = null;
        if ("Random".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new RandomColorProvider(this.jTreeMap);
        } else if ("HSBLinear".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Linear, Color.GREEN, Color.RED);
        } else if ("HSBLog".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Log, Color.GREEN, Color.RED);
        } else if ("HSBSquareRoot".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new RandomColorProvider(this.jTreeMap);
        } else if ("HSBCubicRoot".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.CubicRoot, Color.GREEN, Color.RED);
        } else if ("HSBExp".equalsIgnoreCase(colourProvider)) {
            colourProviderInstance = new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Exp, Color.GREEN, Color.RED);
        }
        if (colourProviderInstance == null) {
            colourProviderInstance = new RedGreenColorProvider(this.jTreeMap);
        }
        this.jTreeMap.setColorProvider(colourProviderInstance);
        new ZoomPopupMenu(this.jTreeMap, true);
        if (this.showTree) {
            JSplitPane splitPaneCenter = new JSplitPane();
            splitPaneCenter.setBorder(BorderFactory.createEmptyBorder());
            this.getJContentPane().add((Component)splitPaneCenter, "Center");
            JScrollPane jScrollPane1 = new JScrollPane();
            splitPaneCenter.setTopComponent(jScrollPane1);
            splitPaneCenter.setBottomComponent(this.jTreeMap);
            this.treeModel = new DefaultTreeModel(root);
            this.treeView = new JTree(this.treeModel);
            this.jTreeMap.setTreeView(this.treeView);
            jScrollPane1.getViewport().add(this.treeView);
            jScrollPane1.setPreferredSize(new Dimension(140, this.jTreeMap.getRoot().getHeight()));
            this.treeView.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreeMapNode dest = (TreeMapNode)JTreeMapAppletExample.this.treeView.getLastSelectedPathComponent();
                    if (dest != null && dest.isLeaf()) {
                        dest = (TreeMapNode)dest.getParent();
                    }
                    if (dest == null) {
                        return;
                    }
                    JTreeMapAppletExample.this.jTreeMap.zoom(dest);
                    JTreeMapAppletExample.this.jTreeMap.repaint();
                }
            });
        } else {
            this.getJContentPane().add((Component)this.jTreeMap, "Center");
        }
    }

    private BufferedReader createReader(String dataFile) throws IOException {
        URL url = new URL(this.getCodeBase() + dataFile);
        URLConnection connection = url.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        return reader;
    }

    private TreeMapNode handleException(Exception e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this, e.getMessage(), "File error", 0);
        return DemoUtil.buildDemoRoot();
    }

    private void addPanelEast(Container parent) {
        this.panelTM3 = new JPanel();
        parent.add((Component)this.panelTM3, "East");
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new GridBagLayout());
        choicePanel.setBorder(new TitledBorder("Choose the TM3 fields"));
        this.panelTM3.add(choicePanel);
        JLabel lblWeight = new JLabel(" weight : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        choicePanel.add((Component)lblWeight, gridBagConstraints);
        this.cmbWeight = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        choicePanel.add((Component)this.cmbWeight, gridBagConstraints);
        this.cmbWeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                String field = (String)cmb.getSelectedItem();
                JTreeMapAppletExample.this.builderTM3.setWeights(field);
                JTreeMapAppletExample.this.repaint();
            }
        });
        JLabel lblValue = new JLabel(" value : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        choicePanel.add((Component)lblValue, gridBagConstraints);
        this.cmbValue = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        choicePanel.add((Component)this.cmbValue, gridBagConstraints);
        this.cmbValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                String field = (String)cmb.getSelectedItem();
                JTreeMapAppletExample.this.builderTM3.setValues(field);
                JTreeMapAppletExample.this.repaint();
            }
        });
        this.panelTM3.setVisible(false);
    }

    private void setTM3Fields() {
        String[] numberFields = this.builderTM3.getNumberFields();
        String[] cmbValues = new String[numberFields.length + 1];
        cmbValues[0] = "";
        for (int i = 1; i < cmbValues.length; ++i) {
            cmbValues[i] = numberFields[i - 1];
        }
        this.cmbWeight.removeAllItems();
        this.cmbValue.removeAllItems();
        for (String item : cmbValues) {
            this.cmbWeight.addItem(item);
            this.cmbValue.addItem(item);
        }
    }

    public void init() {
        this.initGUI();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    public void destroy() {
        super.destroy();
        this.jContentPane.removeAll();
    }
}

