/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.vfs;

import com.atlassian.clover.idea.util.psi.PsiUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.io.File;
import java.net.URL;

public class VfsUtil
extends com.intellij.openapi.vfs.VfsUtil {
    public static URL convertToURL(final VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (VfsUtil.isFileInJar(file)) {
            return null;
        }
        Application app = ApplicationManager.getApplication();
        return (URL)app.runReadAction(new Computable(){

            public Object compute() {
                return com.intellij.openapi.vfs.VfsUtil.convertToURL((String)file.getUrl());
            }
        });
    }

    public static File convertToFile(VirtualFile file) {
        if (file == null) {
            return null;
        }
        URL url = VfsUtil.convertToURL(file);
        if (url == null) {
            return null;
        }
        return new File(url.getFile());
    }

    public static boolean isFileInJar(VirtualFile file) {
        if (file == null) {
            return false;
        }
        String url = file.getUrl();
        return url.startsWith("jar");
    }

    public static String getRootRelativeFilename(Project project, VirtualFile file) {
        return VfsUtil.getRootRelativeFilename(project, file, '/');
    }

    public static String getRootRelativeFilename(Project project, VirtualFile file, char separatorChar) {
        PsiPackage pkg;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        PsiDirectory psiDirectory = psiFile == null ? PsiManager.getInstance((Project)project).findDirectory(file) : psiFile.getContainingDirectory();
        PsiPackage psiPackage = pkg = psiDirectory == null ? null : PsiUtil.getPackage(psiDirectory);
        if (pkg == null) {
            return null;
        }
        String pkgStr = pkg.getQualifiedName();
        String psiFileName = psiFile == null ? "" : psiFile.getName();
        return pkgStr.length() == 0 ? psiFileName : pkgStr.replace('.', separatorChar) + separatorChar + psiFileName;
    }

    public static String calcRelativeToProjectPath(VirtualFile sourceVirtualFile, Project project) {
        String relative = VfsUtil.getRelativePath((VirtualFile)sourceVirtualFile, (VirtualFile)project.getBaseDir(), (char)'/');
        return relative != null ? relative : sourceVirtualFile.getPath();
    }
}

