/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.ui;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.testexplorer.CoverageDataHolder;
import com.atlassian.clover.idea.treetables.TreeTableModelFactory;
import com.atlassian.clover.idea.util.ui.ScrollUtil;
import com.atlassian.clover.registry.FileInfoRegion;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ScrollToSourceMouseAdapter
extends MouseAdapter
implements ConfigChangeListener {
    private final Project project;
    private int requiredClickCount;
    private static final Key<ScrollToSourceMouseAdapter> ADAPTER_PROJECT_KEY = Key.create((String)ScrollToSourceMouseAdapter.class.getName());

    private ScrollToSourceMouseAdapter(Project project) {
        this.project = project;
        IdeaCloverConfig config = ProjectPlugin.getPlugin(project).getConfig();
        config.addConfigChangeListener(this);
        this.requiredClickCount = config.isAutoScroll() ? 1 : 2;
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("autoScroll")) {
            boolean autoScroll = (Boolean)evt.getPropertyChange("autoScroll").getNewValue();
            this.requiredClickCount = autoScroll ? 1 : 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        FileInfoRegion region;
        JTree theTree;
        if (e.getClickCount() != this.requiredClickCount) {
            return;
        }
        Component component = e.getComponent();
        JTree jTree = theTree = component instanceof JTree ? (JTree)component : TreeTableModelFactory.retrieveJTree(component);
        if (theTree == null) {
            return;
        }
        TreePath path = theTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Object object = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (object instanceof FileInfoRegion) {
            region = (FileInfoRegion)object;
        } else if (object instanceof TestCaseInfo) {
            region = ((TestCaseInfo)object).getSourceMethod();
        } else {
            if (!(object instanceof CoverageDataHolder)) return;
            HasMetrics hasMetrics = ((CoverageDataHolder)object).getElement();
            if (!(hasMetrics instanceof FileInfoRegion)) throw new IllegalArgumentException("Unexpected CoverageDataHolder content: " + hasMetrics.getClass());
            region = (FileInfoRegion)((Object)hasMetrics);
        }
        if (region == null) return;
        ScrollUtil.scrollToSourceRegion(this.project, region);
    }

    public static ScrollToSourceMouseAdapter getInstance(Project project) {
        ScrollToSourceMouseAdapter instance = (ScrollToSourceMouseAdapter)project.getUserData(ADAPTER_PROJECT_KEY);
        if (instance == null) {
            instance = new ScrollToSourceMouseAdapter(project);
            project.putUserData(ADAPTER_PROJECT_KEY, (Object)instance);
        }
        return instance;
    }
}

